<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadData", '
    function filterDataTable(branch,date_from,status,date_to)
    {
        var table_id ="#tbl_attendance_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/attendance/GetStatus') . '",
                type: "POST",
                "data" : {
                    "branch_id" : branch,
                    "from_date" : date_from,
                    "date_to" : date_to,
                    "status":status
                },
                cache : false,
                "beforeSend": function(data) {  
                    $("#loader").show();
                },
                "complete": function(data) {  
                    $("#loader").hide();
                }
            },
             columns: [
                {className:"text-center col-max-1"},
                {className:"nw sl col-max-1"},
                {className:"nw sl col-max-2"},
                {className:"nw sl col-max-1"},
                {className:"nw col-max-5"},
                {className:"nw col-max-1 text-center"},
                {className:"nw col-max-1 text-center"},
                {className:"nw col-max-1"},
            ],
            order: [[ 3, "asc" ]],
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );

        $(".dataTables_scrollFoot").hide(); 
    }        
    $(document).ready(function() { 
        var branch       = $("#attendancebranch1").val();
        var status    = $("#attendance_punc_status").val();
        var from_date    = $("#attnd_fromdate").val();
        var date_from = from_date.split("/").reverse().join("-");
        var to_date    = $("#attnd_todate").val();
        var date_to = to_date.split("/").reverse().join("-");
      filterDataTable(branch,date_from,status,date_to);
});', CClientScript::POS_HEAD);
$cs->registerScript("loadAttendance", "function loadAttendance(){  
    $('#tbl_attendance_details').DataTable().destroy();
        var branch       = $('#attendancebranch1').val();
        var status       = $('#attendance_punc_status').val();
        var from_date    = $('#attnd_fromdate').val();
        var date_from = from_date.split('/').reverse().join('-');
        var to_date    = $('#attnd_todate').val();
        var date_to = to_date.split('/').reverse().join('-');
    filterDataTable(branch,date_from,status,date_to);
   
};", CClientScript::POS_HEAD);
$cs->registerScript("excelteamattendanceList", "function excelteamattendanceList(){
        var branch       = $('#attendancebranch1').val();
        var status       = $('#attendance_punc_status').val();
        var employee_id  = $('#employee_id').val();
        var from_date    = $('#attnd_fromdate').val();
        var to_date    = $('#attnd_todate').val();
    window.open($('#liveSite').val()+'index.php?r=hr/hrexcel/PrintEmployeeTeamAttendenceExcel&to_date='+to_date+'&from_date='+from_date+'&branch='+branch+'&status='+status, '_blank');

}", CClientScript::POS_HEAD);
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-calendar"></i> Attendance
        <div class="pull-right">
            <?php echo CHtml::dropdownlist('attendancebranch1', '', MasCompanyBranchSponsor::getCompanyBranches(), array('class' => 'col-sm-3 form-control_1', 'prompt' => 'Branch', 'title' => 'Please Select Branch', 'onchange' => 'loadAttendance();')); ?>
            <?php echo CHtml::dropdownlist('attendance_punc_status', '2', array(1=>'Present',2=>'Absent',3=>'Leave',5=>'Weekend',4=>'Holiday'), array('class' => 'col-sm-3 form-control_1', 'prompt' => 'All Status', 'title' => 'Please Select Status', 'onchange' => 'loadAttendance();')); ?>
            <?php echo CHtml::textField('attnd_fromdate', date("d/m/Y"), array('class' => 'datepicker col-sm-2 form-control_1', 'data-label' => 'Date')); ?>            
            <?php echo CHtml::textField('attnd_todate', date("d/m/Y"), array('class' => 'datepicker col-sm-2 form-control_1', 'data-label' => 'Date')); ?>          
            <a href="javascript:void(0);" onclick="loadAttendance();" class="btn btn-warning">Search</a>
            <a href="javascript:void(0);" onclick="excelteamattendanceList();"class="btn btn-sm btn-theme" title="Download Report" style="margin-right: 10px;"><i class="fa fa-file-excel-o"></i> Excel</a>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_attendance_details" style="font-size: 12px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Branch</th>
                        <th>Date</th>
                        <th>Code</th>
                        <th>Name</th> 
                        <th>Login</th>
                        <th>Logout</th>
                        <th>Status</th>
                    </tr>
                </thead>
            </table>
        </div>
        <input type="hidden" id="attendancemax_date_from" value="<?php echo date("d/m/Y"); ?>" />  
    </div>
</section>
<script type="text/javascript">
    $(function () {
        var max_date = $("#attendancemax_date_from").val().split("/");
        var max_date = new Date(max_date[2], max_date[1] - 1, max_date[0]);
        $('#attnd_fromdate').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'});
    });
</script>
