<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'approve_level-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">   			                     
            <li class="col-sm-4">
                <?php echo CHtml::dropdownlist('branch_detail', '', MasCompanyBranchSponsor::getCompanyBranches(), array('data-label' => 'Branch <span style="color:red">*</span>', 'empty' => 'Select','data-search'=>true, 'onchange' => 'getfunctionality()')); ?>
            </li>
            <li class="col-sm-4" id="li_functionality_id">
                <?php echo CHtml::dropdownlist('functionality_id', '',array(), array('data-label' => 'Functionality <span style="color:red">*</span>', 'empty' => 'Select')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo CHtml::textField('max_level_id', '', array('data-label' => 'Max Level <span style="color:red">*</span>','onkeypress' => 'return isNumberKey(event)','onkeyup'=>'displayfields(this.value);')); ?>
            </li>
            <li class="col-sm-4 li_level_1" style="display: none;">
                <?php
                echo CHtml::DropdownList('set_level_1','',array('L'=>'Line Manager','S'=>'Supervisor','H'=>'Admin Portal','N'=>'Self/ESS Portal'),array('data-label' => 'Level 1 <span style="color:red">*</span>','empty'=>'Select'));
                ?>
            </li>
            <li class="col-sm-4 li_level_1" style="display: none;">
                <?php
                echo CHtml::DropdownList('set_level_1_employee','',Employee::getEmployee(),array('data-label' => 'Level 1 Authority <span style="color:red">*</span>','empty'=>'Select','data-search'=>true, 'onchange' => 'checkemployeeexistinuser(1)'));
                ?>
            </li>
            <li class="col-sm-4 li_level_2" style="display: none;">
                <?php
                echo CHtml::DropdownList('set_level_2','',array('L'=>'Line Manager','S'=>'Supervisor','H'=>'Admin Portal','N'=>'Self/ESS Portal'),array('data-label' => 'Level 2','empty'=>'Select'));
                ?>
            </li>
            <li class="col-sm-4 li_level_2" style="display: none;">
                <?php
                echo CHtml::DropdownList('set_level_2_employee','',Employee::getEmployee(),array('data-label' => 'Level 2 Authority','empty'=>'Select','data-search'=>true, 'onchange' => 'checkemployeeexistinuser(2)'));
                ?>
            </li>
            <li class="col-sm-4 li_level_3" style="display: none;">
                <?php
                echo CHtml::DropdownList('set_level_3','',array('L'=>'Line Manager','S'=>'Supervisor','H'=>'Admin Portal','N'=>'Self/ESS Portal'),array('data-label' => 'Level 3','empty'=>'Select'));
                ?>
            </li>
            <li class="col-sm-4 li_level_3" style="display: none;">
                <?php
                echo CHtml::DropdownList('set_level_3_employee','',Employee::getEmployee(),array('data-label' => 'Level 3 Authority','empty'=>'Select','data-search'=>true, 'onchange' => 'checkemployeeexistinuser(3)'));
                ?>
            </li>
            <li class="col-sm-4 li_level_4" style="display: none;">
                <?php
                echo CHtml::DropdownList('set_level_4','',array('L'=>'Line Manager','S'=>'Supervisor','H'=>'Admin Portal','N'=>'Self/ESS Portal'),array('data-label' => 'Level 4','empty'=>'Select'));
                ?>
            </li>
            <li class="col-sm-4 li_level_4" style="display: none;">
                <?php
                echo CHtml::DropdownList('set_level_4_employee','',Employee::getEmployee(),array('data-label' => 'Level 4 Authority','empty'=>'Select','data-search'=>true, 'onchange' => 'checkemployeeexistinuser(4)'));
                ?>
            </li>
            <li class="col-sm-4 li_level_5" style="display: none;">
                <?php
                echo CHtml::DropdownList('set_level_5','',array('L'=>'Line Manager','S'=>'Supervisor','H'=>'Admin Portal','N'=>'Self/ESS Portal'),array('data-label' => 'Level 5','empty'=>'Select'));
                ?>
            </li>
            <li class="col-sm-4 li_level_5" style="display: none;">
                <?php
                echo CHtml::DropdownList('set_level_5_employee','',Employee::getEmployee(),array('data-label' => 'Level 5 Authority','empty'=>'Select','data-search'=>true, 'onchange' => 'checkemployeeexistinuser(5)'));
                ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="emp_close" data-dismiss="modal">Close</button>
    <a href="javascript:void(0);" onclick="SaveApprovelevel();" class="btn btn-primary"  id="th_approve">Save</a>
</div>
<?php
$this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript("getfunctionality", " function getfunctionality() {
    var branch_id = $('#branch_detail').val();
    if(branch_id!=''){
        jQuery.ajax({
            'type': 'post',
            'dataType': 'json',
            'url': '" . Yii::app()->createUrl('hr/approvelevel/getfunctionality') . "',
            'data': {'branch_id':branch_id},
            'cache': false,
            'success': function(data) {
                $('#li_functionality_id').html(data.functionality);
            }
        });
    }
}", CClientScript::POS_HEAD);
$cs->registerScript("checkemployeeexistinuser", " function checkemployeeexistinuser(frm) {
    $('.toast8-error').hide(); 
    var level_type =$('#set_level_'+frm+'').val();
    var user_id =$('#set_level_'+frm+'_employee').val();
    if(level_type=='H' && user_id>0){
        jQuery.ajax({
            'type': 'post',
            'dataType': 'json',
            'url': '" . Yii::app()->createUrl('hr/approvelevel/checkuserexistwithadmin') . "',
            'data': {'user_id':user_id},
            'cache': false,
            'success': function(data) {
                if(data.status=='error'){
                    t8.error('User doesnot exist with this employee');
                    $('#set_level_'+frm+'_employee').multiselect('select', '');
                    $('#set_level_'+frm+'_employee').multiselect('refresh');
                }
            },
            'beforeSend':function(){
              $('#loader').show();   
            },
            'complete':function(){
              $('#loader').hide();   
            }
        });
    }
}", CClientScript::POS_HEAD);
$cs->registerScript("displayfields", "function displayfields(level) { 
    if(parseInt(level)>=1){
        $('.li_level_1').show();
    }else{
        $('.li_level_1').hide();
    }
    if(parseInt(level)>=2){
        $('.li_level_2').show();
    }else{
        $('.li_level_2').hide();
    }
    if(parseInt(level)>=3){
        $('.li_level_3').show();
    }else{
        $('.li_level_3').hide();
    }
    if(parseInt(level)>=4){
        $('.li_level_4').show();
    }else{
        $('.li_level_4').hide();
    }
    if(parseInt(level)>=5){
        $('.li_level_5').show();
    }else{
        $('.li_level_5').hide();
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("SaveApprovelevel", "function SaveApprovelevel() {
    $('.toast8-error').hide(); 
    jQuery.ajax({
        'dataType':'json',
        'data' : $('#approve_level-form').serialize(),
        'type':'post',
        'url': '" . Yii::app()->createUrl('hr/approvelevel/SaveSameApprovelevel') . "',
        'cache': false,
        'success': function(data) {
            if(data.status=='success'){
                $('#emp_close').click(); 
                t8.success('Details saved');
            }
        },
        'beforeSend':function(){   
            var branch_detail=$('#branch_detail').val();
            if(branch_detail==''){
                t8.error('Please Select Branch');
                return false;
            } 
            var functionality=$('#functionality_id').val();
            if(functionality==''){
                t8.error('Please Select Functionality');
                return false;
            } 
            var max_level=$('#max_level_id').val();
            if(max_level==''){
                t8.error('Please enter Maximum Level');
                return false;
            } 
            var flag_status=0;
            if(max_level>=1){
                var level_1=$('#set_level_1').val();
                if(level_1==''){
                    flag_status=1;
                    t8.error('Please enter level 1 details');
                    return false;
                }else if(level_1=='N' || level_1=='H'){
                    var level_1_e=$('#set_level_1_employee').val();
                    if(level_1_e==''){
                        flag_status=1;
                        t8.error('Please select level 1 authority');
                        return false;
                    }
                } 
            } 
            if(max_level>=2){
                var level_2=$('#set_level_2').val();
                if(level_2==''){
                    flag_status=1;
                    t8.error('Please enter level 2 details');
                    return false;
                }else if(level_2=='N' || level_2=='H'){
                    var level_2_e=$('#set_level_2_employee').val();
                    if(level_2_e==''){
                        flag_status=1;
                        t8.error('Please select level 2 authority');
                        return false;
                    }
                } 
            } 
            if(max_level>=3){
                var level_3=$('#set_level_3').val();
                if(level_3==''){
                    flag_status=1;
                    t8.error('Please enter level 3 details');
                    return false;
                }else if(level_3=='N' || level_3=='H'){
                    flag_status=1;
                    var level_3_e=$('#set_level_3_employee').val();
                    if(level_3_e==''){
                        t8.error('Please select level 3 authority');
                        return false;
                    }
                } 
            } 
            if(max_level>=4){
                var level_4=$('#set_level_4').val();
                if(level_4==''){
                    flag_status=1;
                    t8.error('Please enter level 4 details');
                    return false;
                }else if(level_4=='N' || level_4=='H'){
                    var level_4_e=$('#set_level_4_employee').val();
                    if(level_4_e==''){
                        flag_status=1;
                        t8.error('Please select level 4 authority');
                        return false;
                    }
                } 
            } 
            if(max_level>=5){
                var level_5=$('#set_level_5').val();
                if(level_5==''){
                    flag_status=1;
                    t8.error('Please enter level 5 details');
                    return false;
                }else if(level_5=='N' || level_5=='H'){
                    var level_5_e=$('#set_level_5_employee').val();
                    if(level_5_e==''){
                        flag_status=1;
                        t8.error('Please select level 5 authority');
                        return false;
                    }
                } 
            } 
            if(flag_status==0){
                $('#loader').show();   
            }
        },
        'complete':function(){
              $('#loader').hide();   
        }
    });
};", CClientScript::POS_HEAD);
?>

