<!DOCTYPE html>
<html>
    <head>
        <title>Appraisal Details</title>
        <style>

            @page {
                margin-top: 3.5cm;
                margin-bottom: 3.5cm;
                margin-left: 1cm;
                margin-right: 1cm;
                header: html_myHeader;
                header: html_otherpages;
                footer: html_firstfooter;
            }
            @page :first {
                margin-top: 3.5cm;
                margin-bottom: 3cm;
                header: html_firstpage;
                footer: html_firstfooter;
            }
            @page :last {
                footer: html_lastfooter;
            }
            .box{
                border: 1px solid #002060;
                font-size:11px;
                color: #222;
                min-width: 100%;
                width: 100%;
                background-color: #E5F9FF;
            }
            .box_inside{
                min-width: 100%;
                width: 100%;
                border: none;
            }
        </style>
    </head>

    <body>
        <?php
        $model_pdf_settings = DocumentSettings::model()->find();
        $company_name = "";
        $company_address = "";
        $company_phno = "";
        $company_web_address = "";
        if (!empty($model_pdf_settings)) {
            $company_name = strtoupper($model_pdf_settings->company_name);
            $company_address = $model_pdf_settings->company_address;
            $company_phno = $model_pdf_settings->company_phno;
            $web = substr($model_pdf_settings->company_web_address, 0, 3);
            if ($web != 'www') {
                $company_web_address = 'www.';
            }
            $company_web_address .= $model_pdf_settings->company_web_address;
        } else {
            $model_company = MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id);
            $company_name = strtoupper($model_company->company_name);
            $company_address = $model_company->billing_address;
            $company_phno = $model_company->genral_phno;
            $web = substr($model_company->genral_web, 0, 2);
            if ($web != 'www') {
                $company_web_address = 'www.';
            }
            $company_web_address = $model_company->genral_web;
        }
        if ($model->employeedetail->branch_sponsor->slip_header_name != '') {
            $company_name = $model->employeedetail->branch_sponsor->slip_header_name;
        }
        if ($model->employeedetail->branch_sponsor->branch_or_sponsor_address != '') {
            $company_address = $model->employeedetail->branch_sponsor->branch_or_sponsor_address;
        }
        if ($model->employeedetail->branch_sponsor->branch_or_sponsor_phno != '') {
            $company_phno = $model->employeedetail->branch_sponsor->branch_or_sponsor_phno;
        }
        if ($model->employeedetail->branch_sponsor->branch_or_sponsor_web != '') {
            $company_web_address = $model->employeedetail->branch_sponsor->branch_or_sponsor_web;
        }
        ?>

    <htmlpageheader name="firstpage" style="display:none">
        <div class="logo col-2" >
            <?php
            if ($model_branch->salary_slip_logo != '') {
                ?>
                <img src="uploads/logo/<?php echo $model_branch->salary_slip_logo; ?>">
                <?php
            } else {
                ?>
                <img src="uploads/profilephotos/<?php echo $model_pdf_settings->company_logo; ?>">
                <?php
            }
            ?>
        </div>
        <div class="logo col-9">
            <h3 style="margin: 0px;padding: 0px;font-size: 30px;color: #0070c0;font-weight: bold;"><?php echo $company_name; ?></h3>
            <h6 style="font-size: 11px;font-weight:200;color: #0070c0;margin:0px 0px 0px 0px;"><?php echo trim($company_address); ?>; <?php echo trim($company_phno); ?>; <span style="text-decoration:underline;color:#0000ff;"><?php echo $company_web_address; ?></span></h6>
        </div>
<!--        <div class="heading" style="text-align:center;">
            <h3 style="margin: 0px;padding: 0px;font-size: 30px;color: #0070c0;font-weight: bold;"><?php echo $company_name; ?></h3>
            <h6 style="font-size: 11px;font-weight:200;color: #0070c0;margin:10px 0px 0px 0px;margin-top:1px;"><?php echo $company_address; ?>; <?php echo $company_phno; ?>; <span style="text-decoration:underline;color:#0000ff;"><?php echo $company_web_address; ?></span></h6>
        </div>-->
    </htmlpageheader>
    <htmlpageheader name="otherpages" style="display:none">
        <div class="logo col-2" >
            <?php
            if ($model_branch->salary_slip_logo != '') {
                ?>
                <img src="uploads/logo/<?php echo $model_branch->salary_slip_logo; ?>">
                <?php
            } else {
                ?>
                <img src="uploads/profilephotos/<?php echo $model_pdf_settings->company_logo; ?>">
                <?php
            }
            ?>
        </div>
        <div class="logo col-9">
            <h3 style="margin: 0px;padding: 0px;font-size: 30px;color: #0070c0;font-weight: bold;text-align: center;"><?php echo $company_name; ?></h3>
            <h6 style="font-size: 11px;font-weight:200;color: #0070c0;margin:0px 0px 0px 0px;text-align: center;"><?php echo trim($company_address); ?>; <?php echo trim($company_phno); ?>; <span style="text-decoration:underline;color:#0000ff;text-align: center;"><?php echo $company_web_address; ?></span></h6>
        </div>
<!--        <div class="heading" style="text-align:center;">
            <h3 style="margin: 0px;padding: 0px;font-size: 30px;color: #0070c0;font-weight: bold;"><?php echo $company_name; ?></h3>
            <h6 style="font-size: 11px;font-weight:200;color: #0070c0;margin:10px 0px 0px 0px;margin-top:1px;"><?php echo $company_address; ?>; <?php echo $company_phno; ?>; <span style="text-decoration:underline;color:#0000ff;"><?php echo $company_web_address; ?></span></h6>
        </div>-->
    </htmlpageheader>
    <sethtmlpageheader name="firstpage" value="on" show-this-page="1" />
    <sethtmlpageheader name="otherpages" value="on" />
    <div class="table-body">
        <table class="table table-fixed table-primary dataTable">
            <tbody>
                <tr>
                    <td style="background-color: #d6e2ef; "><b>Employee Code</b></td>
                    <td class="text-right">
                        <?php
                        echo $model->employeedetail->employeecode;
                        ?>
                    </td>
                </tr>
                <tr>
                    <td style="background-color: #d6e2ef; "><b>Employee Name</b></td>
                    <td class="text-right">
                        <?php
                        echo $model->employeedetail->employeefullname;
                        ?>
                    </td>
                </tr>
                <tr>
                    <td style="background-color: #d6e2ef; width: 50%"><b>Joining Date</b></td>
                    <td class="text-right text-bold">
                        <?php
                        if ($model->employeedetail->date_join != '' && $model->employeedetail->date_join != '0000-00-00') {
                            echo date("d/m/Y", strtotime($model->employeedetail->date_join));
                        }
                        ?>
                    </td>
                </tr>
                <tr>
                    <td style="background-color: #d6e2ef; "><b>Department</b></td>
                    <td class="text-right">
                        <?php
                        echo $model->employeedetail->departmentdetail->department_name;
                        ?>
                    </td>
                </tr>
                <tr>
                    <td style="background-color: #d6e2ef; "><b>Designation</b></td>
                    <td class="text-right">
                        <?php
                        echo $model->employeedetail->designationdetail->designation_name;
                        ?>
                    </td>
                </tr>
                <tr>
                    <td style="background-color: #d6e2ef; "><b>Appraisal Detail</b></td>
                    <td class="text-right">
                        <?php
                        echo $model->appraisal_for;
                        ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div><br/>
    <?php if (!empty($model_analysis)): ?>
        <div class="table-body">
            <div style="text-align:center; background-color: #2367f4; color: white;  border-radius: 2px; font-weight: bold" colspan="2">EVALUATION</div>
            <table class="table table-fixed table-primary dataTable">
                <tr>
                    <th class="heady" style="text-align:center; border: none;" colspan="2"></th>
                </tr>
                <?php
                $total_avg_ass = 0;
                $maxscore = $model_settings->appraisal_score;
                foreach ($model_analysis as $i => $detail):
                    $l1_assesment = ($detail->level1_score / $maxscore) * $detail->question_weightage;
                    $l2_assesment = ($detail->level2_score / $maxscore) * $detail->question_weightage;
                    $l3_assesment = ($detail->level3_score / $maxscore) * $detail->question_weightage;
                    $l4_assesment = ($detail->level4_score / $maxscore) * $detail->question_weightage;
                    $l5_assesment = ($detail->level5_score / $maxscore) * $detail->question_weightage;
                    $total_avg_ass += round(($l1_assesment + $l2_assesment + $l3_assesment + $l4_assesment + $l5_assesment) / $model->last_approved_level);
                    ?>
                    <tr style="border: 1px solid black; background-color: #dff0d8">
                        <td class="text-bold" style="width: 25%">Goal</td><td><?php echo $detail->appraisal_goal; ?></td>
                    </tr>
                    <tr style="background-color: #fcf8e3">
                        <td class="text-bold">KPI</td><td><?php echo $detail->question; ?></td>
                    </tr>
                    <tr style="background-color: #d9edf7">
                        <td class="text-bold">Date</td><td><?php echo date('d/m/Y',strtotime($detail->target_achieved_date)); ?></td>
                    </tr>
                    <?php
                    //Level 1-Start
                    if ($model->last_approved_level >= 1) {
                        ?>
                        <tr>
                            <td style="background-color: #FFF9C4; font-weight: bold;">Level 1 Review</td>
                            <td style="background-color: #FFF9C4;"><?php echo $detail->level1_answer; ?></td>
                        </tr>
                        <tr>
                            <td style="background-color: #d6d4fc; font-weight: bold;">Level 1 Rating Out of <span style="color: red; font-weight: bold"><?php echo $model_settings->appraisal_score; ?></span></td>
                            <td style="background-color: #d6d4fc;"><?php echo $detail->level1_score; ?></td>
                        </tr>
                        <?php
                    } //Level 1 End
                    //Level 2 Start
                    if ($model->last_approved_level >= 2) {
                        ?>
                        <tr>
                            <td style="background-color: #FFF9C4; font-weight: bold;">Level 2 Review</td>
                            <td style="background-color: #FFF9C4;"><?php echo $detail->level2_answer; ?></td>
                        </tr>
                        <tr>
                            <td style="background-color: #d6d4fc; font-weight: bold;">Level 2 Rating Out of <span style="color: red; font-weight: bold"><?php echo $model_settings->appraisal_score; ?></span></td>
                            <td style="background-color: #d6d4fc;"><?php echo $detail->level2_score; ?></td>
                        </tr>
                        <?php
                    }
                    //Level 2 End
                    //Level 3 Start
                    if ($model->last_approved_level >= 3) {
                        ?>
                        <tr>
                            <td style="background-color: #FFF9C4; font-weight: bold;">Level 3 Review</td>
                            <td style="background-color: #FFF9C4;"><?php echo $detail->level3_answer; ?></td>
                        </tr>
                        <tr>
                            <td style="background-color: #d6d4fc; font-weight: bold;">Level 3 Rating Out of <span style="color: red; font-weight: bold"><?php echo $model_settings->appraisal_score; ?></span></td>
                            <td style="background-color: #d6d4fc;"><?php echo $detail->level3_score; ?></td>
                        </tr>
                        <?php
                    }
                    //Level 3 End
                    //Level 4 Start
                    if ($model->last_approved_level >= 4) {
                        ?>
                        <tr>
                            <td style="background-color: #FFF9C4; font-weight: bold;">Level 4 Review</td>
                            <td style="background-color: #FFF9C4;"><?php echo $detail->level4_answer; ?></td>
                        </tr>
                        <tr>
                            <td style="background-color: #d6d4fc; font-weight: bold;">Level 4 Rating Out of <span style="color: red; font-weight: bold"><?php echo $model_settings->appraisal_score; ?></span></td>
                            <td style="background-color: #d6d4fc;"><?php echo $detail->level4_score; ?></td>
                        </tr>
                        <?php
                    }
                    //Level 4 End
                    //Level 5 Start
                    if ($model->last_approved_level >= 5) {
                        ?>
                        <tr>
                            <td style="background-color: #FFF9C4; font-weight: bold;">Level 5 Review</td>
                            <td style="background-color: #FFF9C4;"><?php echo $detail->level5_answer; ?></td>
                        </tr>
                        <tr>
                            <td style="background-color: #d6d4fc; font-weight: bold;">Level 5 Rating Out of <span style="color: red; font-weight: bold"><?php echo $model_settings->appraisal_score; ?></span></td>
                            <td style="background-color: #d6d4fc;"><?php echo $detail->level5_score; ?></td>
                        </tr>
                        <?php
                    }
                    //Level 5 End
                endforeach;
                $total_type = HrAppraisalType::model()->count(array('condition' => 'appraisal_id=' . $model->id));
                $typeweitage = 100 / $total_type;
                $total = round((($total_avg_ass) * $typeweitage / 100));
                $employee_final_grade = '';
                $final_grade = HrMasAppraisalGrade::getGrade(round($total));
                if ($final_grade) {
                    $employee_final_grade = $final_grade->grade;
                }
                ?>
                <tr>#C8E6C9
                    <td style="background-color: #C8E6C9; font-weight: bold; color: red;">GRADE</td>
                    <td style="background-color: #C8E6C9;  font-weight: bold; color: red;"><?php echo $employee_final_grade ?> (<?php echo $total ?>)</td>
                </tr>
            </table>
        <?php endif; ?>
    </body>
</html>
