<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadAppraisal", 'function filterDataTable() {
         var table_id ="#tbl_appraisal_details";
        var employee_id = $("#appraisal_employee_id").val();
        var status = $("#appraisal_status").val();
        var branch_id = $("#appraisal_branch_id").val();
         var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/appraisal/GetAppraisalList') . '",
                type: "POST",
                data : {
                    "status" : status,"employee_id":employee_id,"branch_id" : branch_id                 
                },
                cache : false,
            },
            columnDefs: [
            ],
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        });
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  		
        filterDataTable();
         materializing(".material");   
    })', CClientScript::POS_HEAD);
$cs->registerScript("appraisaldetails", "function appraisaldetails(){  
    $('#tbl_appraisal_details').DataTable().destroy();
    filterDataTable();  
};", CClientScript::POS_HEAD);
$cs->registerScript("deleteappraisaldetail", "function deleteappraisaldetail(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {	
            jQuery.ajax({
                'type'      : 'post',
                'data'      : 'id=' + id,
                'dataType'  : 'json',  
                'url'       : $('#liveSite').val()+'index.php?r=hr/appraisal/deleteappraisaldetail',
                'cache'     : false,
                'success'   :function(data){
                    if(data.status=='success'){
                        t8.success('Deleted SuccessFully!');
                        reloadTable('#tbl_appraisal_details');
                    }else {
                        t8.error('Error while Delete');
                    }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[9].review_appraisal !== 0) {
            items.reviewappraisal = {
                name: "Review Appraisal",
                icon: "fa-tasks",
                callback: function () {
                    loadPopupModal("hr/appraisal/reviewbylm&final_level=" + datas[9].final_level+"&level="+datas[9].level_no+"&id="+datas[9].id, "Review Appraisal", "xl");
                }
            };
        }
        if (datas[9].delete_appraisal !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash-o ",
                callback: function () {
                    deleteappraisaldetail(datas[9].id);
                }
            };
        }

        if (datas[9].view_appraisal !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/appraisal/view&id=" + datas[9].id, "View Appraisal Detail", "xl");
                }
            };
        }
        if (datas[9].print_appraisal !== 0) {
            items.print = {
                name: "Print",
                icon: "fa-file-pdf-o",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/appraisal/PrintappraisalReportPDF&id=" + datas[9].en_slip_id, "_blank");
                }
            };
        }
        if (datas[9].print_appraisal !== 0) {
            items.print = {
                name: "Print",
                icon: "fa-file-pdf-o",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/appraisal/PrintEmployeeAppraisalGradeReview&id=" + datas[9].en_slip_id, "_blank");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>

 <style>
    #employeeappraisalindexdropdown .material-select-label {
        display: none;
    }
    </style>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame"> Appraisal
        <div class="pull-right dis-flx">
        <div class="material col-sm-12 pd-zero" id="employeeappraisalindexdropdown">   
        
             <span class="col-sm-4 pull-right"> 
           <?php
                $dropdown_list=array();
                $model_approval_status=HrEmployeeApproveLevel::model()->with('employeedetail')->find(array('select'=>'max(max_level) as max_level','condition' =>'employeedetail.branch_or_sponsor_id="'.$branch.'" and functionality_id="6"'));
                $max_level=$model_approval_status->max_level;
                $selected='H';
                if($max_level<=1){
                    $dropdown_list=array(
                        1 => "Added",
                        2 => "Level 1 Pending",
                        3 => "Level 1 Completed", 
                        12 => "Reviewed",
                    );
                }else if($max_level<=2){
                    $dropdown_list=array(
                        1 => "Added",
                        2 => "Level 1 Pending",
                        3 => "Level 1 Completed",
                        4 => "Level 2 Pending",
                        5 => "Level 2 Completed", 
                        12 => "Reviewed",
                    );
                }else if($max_level<=3){
                    $dropdown_list=array(
                        1 => "Added",
                        2 => "Level 1 Pending",
                        3 => "Level 1 Completed",
                        4 => "Level 2 Pending",
                        5 => "Level 2 Completed", 
                        6 => "Level 3 Pending",
                        7 => "Level 3 Completed",  
                        12 => "Reviewed",
                    );
                }else if($max_level<=4){
                    $dropdown_list=array(
                        1 => "Added",
                        2 => "Level 1 Pending",
                        3 => "Level 1 Completed",
                        4 => "Level 2 Pending",
                        5 => "Level 2 Completed", 
                        6 => "Level 3 Pending",
                        7 => "Level 3 Completed", 
                        8 => "Level 4 Pending",
                        9 => "Level 4 Completed", 
                        12 => "Reviewed",
                    );
                }else if($max_level<=5){
                    $dropdown_list=array(
                        1 => "Added",
                        2 => "Level 1 Pending",
                        3 => "Level 1 Completed",
                        4 => "Level 2 Pending",
                        5 => "Level 2 Completed", 
                        6 => "Level 3 Pending",
                        7 => "Level 3 Completed", 
                        8 => "Level 4 Pending",
                        9 => "Level 4 Completed", 
                        10 => "Level 5 Pending",
                        11 => "Level 5 Completed", 
                        12 => "Reviewed",
                    );
                }
                $dropdown_list['H']='Waiting For HR Review';
                echo CHtml::dropdownlist('appraisal_status',$selected,$dropdown_list,  array('title' => 'Please select Status','data-search'=>true,'multiple' => true,'onchange'=>'appraisaldetails()')); 
                ?>
                </span>
                <span class="col-sm-4 pull-right">  
            <?php echo CHtml::dropDownList("appraisal_employee_id",'',Employee::getEmployee($branch), array( 'empty' => 'Select Employee', 'title' => 'Employee Name','data-label'=>'Employee Name','data-search'=>true,'onchange'=>'appraisaldetails();')); ?>                           
             </span>
            </div>
            <input type="hidden" id="appraisal_branch_id" name="appraisal_branch_id" value="<?php echo  $branch; ?>"/>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['appraisal_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn"  onclick="loadPopupModal('hr/appraisal/create&branch=<?php echo $branch; ?>','Add Appraisal','xl')">
                                  
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_appraisal_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Department</th>
                        <th>Designation</th>
                        <th>Joining Date</th>
                        <th>Appraisal For</th>
                        <th>Created Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
