<?php

/**
 * This is the model class for table "{{hr_salary_slip}}".
 *
 * The followings are the available columns in table '{{hr_salary_slip}}':
 * @property integer $id
 * @property integer $salary_processing_id
 * @property integer $employee_id
 * @property string $salary_advance_amount
 * @property string $leave_amount
 * @property string $loan_amount
 * @property string $normal_ot_hour
 * @property string $normal_overtime_amount
 * @property string $holiday_ot_hour
 * @property string $holiday_overtime_amount
 * @property string $leave_encashment_amount
 * @property string $leave_settlement_amount
 * @property string $pension_amount
 * @property string $gratuity_amount
 * @property string $total_salary_amount
 * @property string $employee_salary_amount
 * @property string $total_addition_amount
 * @property string $total_deduction_amount
 * @property string $remarks
 * @property string $salary_posted
 * @property string $wps_posted
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
Yii::import('application.modules.finance.models.FinanceSubledger');

class SalarySlip extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $overtime_amount_1;
    public $deduction_percentage;
    public $old_other_deduction;
    public $old_total_deduction_amount;
    public $old_total_salary_amount;
    public function tableName() {
        return '{{hr_salary_slip}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('salary_processing_id, employee_id, salary_advance_amount, leave_amount, loan_amount, total_salary_amount, employee_salary_amount, total_addition_amount, total_deduction_amount', 'required'),
            array('salary_processing_id, employee_id, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('salary_advance_amount, leave_amount, loan_amount,overtime_amount, pension_amount, gratuity_amount, total_salary_amount, employee_salary_amount, total_addition_amount, total_deduction_amount', 'length', 'max' => 15),
            array('salary_posted, wps_posted', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, salary_processing_id, employee_id, salary_advance_amount, leave_amount, loan_amount,overtime_hour, overtime_amount,pension_amount, gratuity_amount, total_salary_amount, employee_salary_amount, total_addition_amount, total_deduction_amount, remarks, salary_posted, wps_posted, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
            'processing' => array(self::BELONGS_TO, 'SalaryProcessing', 'salary_processing_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'salary_processing_id' => 'Salary Processing',
            'employee_id' => 'Employee',
            'salary_advance_amount' => 'Salary Advance Amount',
            'leave_amount' => 'Leave Amount',
            'loan_amount' => 'Loan Amount',
            'overtime_hour' => 'Overtime Hour',
            'overtime_amount' => 'Overtime Amount',
            'pension_amount' => 'Pension Amount',
            'gratuity_amount' => 'Gratuity Amount',
            'total_salary_amount' => 'Total Salary Amount',
            'employee_salary_amount' => 'Employee Salary Amount',
            'total_addition_amount' => 'Total Additions Amount',
            'total_deduction_amount' => 'Total Deduction Amount',
            'remarks' => 'Remarks',
            'salary_posted' => 'Salary Posted',
            'wps_posted' => 'Wps Posted',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('salary_processing_id', $this->salary_processing_id);
        $criteria->compare('employee_id', $this->employee_id);
        $criteria->compare('salary_advance_amount', $this->salary_advance_amount, true);
        $criteria->compare('leave_amount', $this->leave_amount, true);
        $criteria->compare('loan_amount', $this->loan_amount, true);
        $criteria->compare('overtime_hour', $this->overtime_hour, true);
        $criteria->compare('overtime_amount', $this->overtime_amount, true);
        $criteria->compare('leave_encashment_amount', $this->leave_encashment_amount, true);
        $criteria->compare('leave_settlement_amount', $this->leave_settlement_amount, true);
        $criteria->compare('pension_amount', $this->pension_amount, true);
        $criteria->compare('gratuity_amount', $this->gratuity_amount, true);
        $criteria->compare('total_salary_amount', $this->total_salary_amount, true);
        $criteria->compare('employee_salary_amount', $this->employee_salary_amount, true);
        $criteria->compare('total_addition_amount', $this->total_addition_amount, true);
        $criteria->compare('total_deduction_amount', $this->total_deduction_amount, true);
        $criteria->compare('remarks', $this->remarks, true);
        $criteria->compare('salary_posted', $this->salary_posted, true);
        $criteria->compare('wps_posted', $this->wps_posted, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return SalarySlip the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getmonth($monthvalue) {
        if ($monthvalue == 1) {
            $month = "January";
        } else if ($monthvalue == 2) {
            $month = "February";
        } else if ($monthvalue == 3) {
            $month = "March";
        } else if ($monthvalue == 4) {
            $month = "April";
        } else if ($monthvalue == 5) {
            $month = "May";
        } else if ($monthvalue == 6) {
            $month = "June";
        } else if ($monthvalue == 7) {
            $month = "July";
        } else if ($monthvalue == 8) {
            $month = "August";
        } else if ($monthvalue == 9) {
            $month = "September";
        } else if ($monthvalue == 10) {
            $month = "October";
        } else if ($monthvalue == 11) {
            $month = "November";
        } else if ($monthvalue == 12) {
            $month = "December";
        }
        return $month;
    }

    public function generateSubledger() {
        $user_id = 0;
        $subledger_id = 0;
        if ($this->employee_id > 0)
            $user_id = User::model()->find(array('condition' => 'employee_id=' . $this->employee_id))->id;
        if ($user_id > 0)
            $subledger_id = FinanceSubledger::model()->find(array('condition' => 'subledger_type_id=3 AND parent_id=' . $user_id))->id;
        return $subledger_id;
    }
    public static function getEmployee($id = 0) {
        $condition = '1=1';
        if ($id > 0) {
            $condition.=' AND salary_processing_id="'.$id.'"';
        }
        $model = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $arr_employee = array();
        $employee_details = array();
        foreach ($model as $key => $value) {
            $arr_employee[Yii::app()->controller->ciphertext($value->employeedetail->first_name, "d") . ' ' . Yii::app()->controller->ciphertext($value->employeedetail->last_name, "d"). '-' . Yii::app()->controller->ciphertext($value->employeedetail->employee_code, "d")] = $value->employee_id;
        }
        ksort($arr_employee);
        $m = 0;
        foreach ($arr_employee as $k => $id) {
            $employee_details[$m]['id'] = Yii::app()->controller->ciphertext($id,"e");
            $model_employee = Employee::model()->findbyPK($id);
            $employee_details[$m]['name'] = $model_employee->employeefullname." ( ".$model_employee->employeecode." ) ";
            $m++;
        }
        return CHtml::listData($employee_details, 'id', 'name');
    }
    
     public static function getSalaryEmployee($id = 0) {
        $condition = '1=1';
        $model_salary_processing = SalaryProcessing::model()->findByPK($id);
        $condition = 'E.isActive="Y"  AND E.date_join<="' . $model_salary_processing->payroll_enddate . '"  AND E.branch_or_sponsor_id="' . $model_salary_processing->payroll_branch_or_sponsor_id . '"';
        $SQL = " SELECT * FROM  `erp_hr_employee` E WHERE $condition && id 
                   NOT IN (SELECT  employee_id FROM  erp_hr_salary_slip S WHERE E.id=S.employee_id AND salary_processing_id ='".$id."')";
        $model = Yii::app()->db->createCommand($SQL)->queryAll();
      // $model = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $arr_employee = array();
        $employee_details = array();
        
        
        foreach ($model as $key => $value) {
            $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d"). '-' . Yii::app()->controller->ciphertext($value['employee_code'], "d")] = $value['id'];
        }
        ksort($arr_employee);
        $m = 0;
        foreach ($arr_employee as $k => $id) {
            $employee_details[$m]['id'] = Yii::app()->controller->ciphertext($id,"e");
            $employee_details[$m]['name'] = Employee::model()->findbyPK($id)->employeefullname;;
            $m++;
        }
        return CHtml::listData($employee_details, 'id', 'name');
    }

}
