<?php

/**
 * This is the model class for table "{{hr_room_setting}}".
 *
 * The followings are the available columns in table '{{hr_room_setting}}':
 * @property integer $id
 * @property string $building_name
 * @property integer $country_id
 * @property string $location_name
 * @property string $address
 * @property integer $no_rooms
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class RoomSetting extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_room_setting}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('building_name, country_id, address, no_rooms', 'required'),
			array('country_id, no_rooms, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('building_name, location_name', 'length', 'max'=>500),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, building_name, country_id, location_name, address, no_rooms, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'country' => array(self::BELONGS_TO, 'MasCountry', 'country_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'building_name' => 'Building Name',
			'country_id' => 'Country',
			'location_name' => 'Location Name',
			'address' => 'Address',
			'no_rooms' => 'Total Number of rooms',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('building_name',$this->building_name,true);
		$criteria->compare('country_id',$this->country_id);
		$criteria->compare('location_name',$this->location_name,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('no_rooms',$this->no_rooms);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RoomSetting the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getfloordetail() {
            $condition = 'isActive="Y"';
            $model = self::model()->findAll(array('condition' => $condition, 'order' => 'building_name'));
            return CHtml::listData($model, 'id', 'building_name');
        }
}
