<?php

/**
 * This is the model class for table "{{hr_monthly_salary_sif_details}}".
 *
 * The followings are the available columns in table '{{hr_monthly_salary_sif_details}}':
 * @property integer $id
 * @property integer $sif_file_id
 * @property integer $employee_id
 * @property integer $created_by
 * @property string $created_date
 */
class MonthlySalarySifDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_monthly_salary_sif_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id,personal_file_no,iban_no,employee_wpscode,start_date,end_date,basic_salary,total_salary_paid,created_by, created_date', 'required','on' => 'wpspayment'),
                        array('employee_id,personal_file_no,employee_wpscode,start_date,end_date,basic_salary,total_salary_paid,created_by, created_date', 'required','on' => 'exchange'),
			array('employee_id,start_date,end_date,salary_amount,total_salary_paid,created_by, created_date', 'required','on' => 'cashpayment'),
                        array('employee_id,bank_id,start_date,end_date,salary_amount,total_salary_paid,created_by, created_date', 'required','on' => 'chequepayment'),
                        array('sif_file_id, employee_id,total_days, created_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, sif_file_id, employee_id, created_by, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'salarysif' => array(self::BELONGS_TO, 'MonthlySalarySif', 'sif_file_id'),
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'sif_file_id' => 'Sif File',
			'employee_id' => 'Employee',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('sif_file_id',$this->sif_file_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MonthlySalarySifDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function generateSubledger(){
		$user_id  = 0;
		$subledger_id = 0;
		if( $this->employee_id > 0 )
			$user_id =  User::model()->find( array( 'condition' => 'employee_id='.$this->employee_id ) )->id;
		if( $user_id > 0 )
			$subledger_id = FinanceSubledger::model()->find( array( 'condition' => 'subledger_type_id=3 AND parent_id='.$user_id ) )->id;
		return $subledger_id;
	}

	public function getTotal(){
		return (float) ( $this->basic_salary + $this->salary_amount );
	}
}
