<?php

/**
 * This is the model class for table "crm_hr_monthly_salary_sif".
 *
 * The followings are the available columns in table 'crm_hr_monthly_salary_sif':
 * @property integer $id
 * @property integer $wpscompany_id
 * @property integer $salary_processing_id
 * @property string $salary_month
 * @property string $total_amount
 * @property string $posted
 * @property integer $created_by
 * @property string $created_date
 */
class MonthlySalarySif extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_monthly_salary_sif}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('wpscompany_id,salary_payment_mode, date, salary_processing_id, salary_month, created_by, created_date', 'required'),
			array('wpscompany_id,salary_payment_mode, salary_processing_id, created_by', 'numerical', 'integerOnly'=>true),
			array('salary_month', 'length', 'max'=>50),
			array('total_amount', 'length', 'max'=>15),
			array('posted', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, wpscompany_id, salary_processing_id, salary_month, total_amount, posted, created_by, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'wpscompany_detail' => array(self::BELONGS_TO, 'MasCompanyWpsDetails', 'wpscompany_id'),
			'items' => array(self::HAS_MANY, 'MonthlySalarySifDetails', 'sif_file_id', 'order' => 'items.id asc'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'wpscompany_id' => 'Wpscompany',
			'salary_processing_id' => 'Salary Processing',
			'salary_month' => 'Salary Month',
			'total_amount' => 'Total Amount',
			'posted' => 'Posted',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'legder_id' => 'Ledger',
			'sublegder_id' => 'Subledger',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('wpscompany_id',$this->wpscompany_id);
		$criteria->compare('salary_processing_id',$this->salary_processing_id);
		$criteria->compare('salary_month',$this->salary_month,true);
		$criteria->compare('total_amount',$this->total_amount,true);
		$criteria->compare('posted',$this->posted,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MonthlySalarySif the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
