<?php

/**
 * This is the model class for table "{{hr_master_salary_lock}}".
 *
 * The followings are the available columns in table '{{hr_master_salary_lock}}':
 * @property integer $id
 * @property integer $payroll_branch
 * @property integer $payroll_month
 * @property integer $payroll_year
 */
class MasterSalaryLock extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_master_salary_lock}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('payroll_month, payroll_year', 'required'),
                        array('payroll_branch', 'unique','on'=>'add','message'=>'Branch has been already added'),
			array('payroll_branch, payroll_year', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, payroll_branch, payroll_month, payroll_year', 'safe', 'on'=>'search'),
		);
	}
        function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 24;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' salary lock '.$this->payroll_year;
        $model_audit_log->save();
    }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'branch_sponsor' => array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'payroll_branch'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'payroll_branch' => 'Payroll Branch',
			'payroll_month' => 'Payroll Month',
			'payroll_year' => 'Payroll Year',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('payroll_branch',$this->payroll_branch);
		$criteria->compare('payroll_month',$this->payroll_month);
		$criteria->compare('payroll_year',$this->payroll_year);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasterSalaryLock the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
