<?php

/**
 * This is the model class for table "crm_mas_pension".
 *
 * The followings are the available columns in table 'crm_mas_pension':
 * @property integer $id
 * @property integer $company_percent
 * @property integer $employee_percent
 * @property string $created_date
 * @property string $updated_date
 * @property integer $created_id
 * @property integer $updated_id
 */
class MasPension extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MasPension the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_mas_pension}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_percent, employee_percent,scheme_name', 'required'),
			array('created_id, updated_id', 'numerical', 'integerOnly'=>true),
			array('updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, company_percent, employee_percent,,salary_type,nationality,sex, created_date, updated_date, created_id, updated_id', 'safe', 'on'=>'search'),
		);
	}
        function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 37;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' pension settings  '.$this->nationality;
        $model_audit_log->save();
    }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'nationality_detail' => array(self::BELONGS_TO, 'MasCountry', 'nationality')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_percent' => 'Company Percent',
			'employee_percent' => 'Employee Percent',
                        'salary_type' => 'Salary Type',
                        'nationality' => 'Nationality',
                        'sex' => 'Gender',
			'created_date' => 'Created Date',
			'updated_date' => 'Updated Date',
			'created_id' => 'Created',
			'updated_id' => 'Updated',
                    'min_amount' => 'Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
            $criteria=new CDbCriteria;
            $search = trim(Yii::app()->request->getParam('search'));
            if (!empty($search)){
                $criteria->addCondition('nationality like "%' . $search . '%"', 'AND');
            }
            return new CActiveDataProvider($this, array(
                    'pagination' => array(
                    'pageSize' => 12,
                ),
                    'criteria' => $criteria,
                    'sort' => array(
                    'defaultOrder' => 'nationality ASC',
                ),
            ));
	}
    public function getschemecode() {
        return ($this->scheme_name. ' (' . $this->employee_percent . ' %)');
    }
    public static function getPensionScheme() {
        $condition = 'isActive="Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'scheme_name'));
        return CHtml::listData($model, 'id', 'schemecode');
    }
  
}
