<?php

/**
 * This is the model class for table "{{mas_gratuity}}".
 *
 * The followings are the available columns in table '{{mas_gratuity}}':
 * @property integer $id
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 */
class MasGratuity extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $salary_type_name;
    public function tableName() {
        return '{{hr_mas_gratuity}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('contract_type,gratuity_type,gratuity_period_from,gratuity_period_to,salary_type,days_from,days_to,pay_cal,max_year,gratuity_provision_days', 'required'),
            array('gratuity_type', 'length', 'max' => 255),
            array('gratuity_type', 'validategratuity'),
         //   array('gratuity_type', 'unique', 'on' => 'add'),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, gratuity_type,gratuity_period_from,gratuity_period_to,salary_type,amount, isActive', 'safe', 'on' => 'search'),
        );
    }
    function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 20;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' Eos gratuity '.$this->gratuity_type;
        $model_audit_log->save();
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'contracttype' => array(self::BELONGS_TO, 'HrMasJobContract', 'contract_type'),
            'stype' => array(self::BELONGS_TO, 'MasSalarytype', 'salary_type'),
            'gratuityrule' => array(self::BELONGS_TO, 'HrMasGratuityRuleType', 'rule_type')
        );
    }
    public function validategratuity() {
        if ($this->contract_type!= '' && $this->gratuity_type!='') {
            $condition='contract_type="'.$this->contract_type.'" and releaving_type="'.$this->releaving_type.'" and gratuity_type="'.$this->gratuity_type.'"';
            if($this->id!=''){
                $condition.=' AND id!="'.$this->id.'"';
            }
            $model = self::model()->find(array('condition'=>$condition));
            if($model->id>0){
                $this->addError('gratuity_type', 'Gratuity Detail already exist for this contract');
                return false;
            }else{
                return true;
            }
        }
        
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'gratuity_type'=>'Type',
            'gratuity_period_from'=>'Period From',
            'gratuity_period_to' => 'Period To',
            'salary_type'=>'Salary Type',
            'days_from'=>'Days From',
            'pay_cal'=>'Pay of Scale',
            'gratuity_provision_days'=>'Gratuity Provision Days',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return  the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }



    public static function getGratuity() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'gratuity_type');
    }

    public static function listYears($start_year,$end_year) {
        $arr_years = array();
        for ($i=$start_year;$i<=$end_year;$i++){
          $arr_years[$i]=$i;
        }
        return $arr_years;
    }

}
