<?php

/**
 * This is the model class for table "crm_employee_documents".
 *
 * The followings are the available columns in table 'crm_employee_documents':
 * @property integer $id
 * @property integer $employee_id
 * @property string $description
 * @property string $document_number
 * @property string $validate_till_date
 * @property string $renew_on
 */
class MasExpiryStatus extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmployeeDocument the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_mas_expiry_status}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('document,processing_order,stages', 'required'),
                        //array('document', 'unique','on'=>'add', 'message'=>'Document already exist'),
			array('document,processing_order', 'numerical', 'integerOnly'=>true),
			array('stages', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, document,processing_order, stages, start_date', 'safe', 'on'=>'search'),
		);
	}
        function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 29;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' document expiry status '.$this->stages;
        $model_audit_log->save();
    }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'doc' => array(self::BELONGS_TO, 'MasDocument', 'document'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'document' => 'Document',
			'stages' => 'Stages',
                        'start_date' => 'Start Date',
		);
	}

        
         public function search() {
         
         //   $searchterm =trim(Yii::app()->request->getParam('search'));
        $searchterm =$_GET['search'];
        $criteria_1 = new CDbCriteria();
        $criteria_1->with = array('doc');
        $criteria_1->group = 'doc.document_name';
       if($sterm)
        {
        $criteria->addCondition('doc.document_name like "%' . $searchterm . '%"', 'AND');
        }
       
        print_r($searchterm); //exit;
        if (!empty($searchterm)) {  echo 'hi';
           // $criteria_1->addCondition('doc.document_name="%'.$searchterm.'%"', 'AND');
             $criteria_1->condition = 'doc.document_name="%'.$searchterm.'%"';
        }
        $model_document = MasExpiryStatus::model()->findAll($criteria_1);
        $model_document_list=  array();
        foreach($model_document as $i=>$each){  
            $criteria = new CDbCriteria();
            $criteria->select = array('GROUP_CONCAT(stages ORDER BY processing_order SEPARATOR \', \') AS stages');
            $criteria->condition = "document ='".$each->document."'";
            $model_stage = MasExpiryStatus::model()->find($criteria);
            $model_document_list[$i]["id"]=$each->document;
            $model_document_list[$i]["document_name"]=$each->doc->document_name;
            $model_document_list[$i]["stage"]=$model_stage->stages;
        }    
            return new CArrayDataProvider($model_document_list, array(
		// 'id'=>'id',
		'pagination'=>array(
			'pageSize'=>12,
		),
	));
        
    }
    public static function getExpiryStatus($id,$inprocess) {
        $model = EmployeeInprocessDocument::model()->with('pro_stage')->findAll(array('condition' => 'document_id="'.$inprocess.'" and completed="N"','order'=>'pro_stage.processing_order asc'));
//        $model = self::model()->findAll(array('condition'=>$condition,'order'=>'processing_order asc'));
        return CHtml::listData($model, 'id', 'pro_stage.stages');
    } 
	
    public static function getCompanyExpiryStatus($document_id) {
        $model = CompanyInprocessDocument::model()->with('pro_stage')->findAll(array('condition' => 'document_id="'.$document_id.'" and completed="N"','order'=>'pro_stage.processing_order asc'));		  
        return CHtml::listData($model, 'pro_stage.id', 'pro_stage.stages');
    } 
	
    public static function getEmployeeExpiryStatus($document_id,$employee_id) {
        $model = HrEmployeeInprocessDocument::model()->with('pro_stage')->findAll(array('condition' => 'document_id="'.$document_id.'" and completed="N" and employee_id="'.$employee_id.'"','order'=>'pro_stage.processing_order asc'));		  
        return CHtml::listData($model, 'pro_stage.id', 'pro_stage.stages');
    } 
}