<?php

/**
 * This is the model class for table "{{hr_mas_business_unit}}".
 *
 * The followings are the available columns in table '{{hr_mas_business_unit}}':
 * @property integer $id
 * @property string $business_unit_name
 * @property string $document_name
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class MasBusinessUnit extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_mas_business_unit}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('business_unit_name, document_name', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('business_unit_name, document_name', 'length', 'max'=>700),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, business_unit_name, document_name, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}
        function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 33;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' business unit  '.$this->business_unit_name;
        $model_audit_log->save();
    }


	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'business_unit_name' => 'Business Unit Name',
			'document_name' => 'Document Name',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('business_unit_name',$this->business_unit_name,true);
		$criteria->compare('document_name',$this->document_name,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasBusinessUnit the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
