<?php

/**
 * This is the model class for table "{{hr_training}}".
 *
 * The followings are the available columns in table '{{hr_training}}':
 * @property integer $id
 * @property integer $course_id
 * @property string $provider_name
 * @property string $course_date
 * @property string $fee_per_head
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class HrTraining extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_training}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('course_id,sub_course_id, provider_name, course_date, fee_per_head', 'required'),
			array('course_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('provider_name', 'length', 'max'=>700),
			array('fee_per_head', 'length', 'max'=>10),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, course_id, provider_name, course_date, fee_per_head, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'coursedetail' => array(self::BELONGS_TO, 'HrMasTrainingCourse', 'course_id'),
                    'subcoursedetail' => array(self::BELONGS_TO, 'HrMasTrainingCourseDetail', 'sub_course_id'),
                    'trainingitems' => array(self::HAS_MANY, 'HrTrainingDetails', 'training_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'course_id' => 'Course',
                        'sub_course_id' => 'Training Module',
			'provider_name' => 'Provider Name',
			'course_date' => 'Course Date',
			'fee_per_head' => 'Fee Per Head',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('course_id',$this->course_id);
		$criteria->compare('provider_name',$this->provider_name,true);
		$criteria->compare('course_date',$this->course_date,true);
		$criteria->compare('fee_per_head',$this->fee_per_head,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrTraining the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getmailstatus($training_id = 0) {
            $status=0;
            $model = self::model()->findbyPK($training_id);
            if($model->mail_sent_ids==''){
                $status=1;
            }else{
                $sent_mail_array=  explode(',',$model->mail_sent_ids);
                $model_details= HrTrainingDetails::model()->findAll(array('condition' => 'training_id="'. $training_id.'"'));
                foreach ($model_details as $key => $value) {
                    if (!in_array($value->employee_id,$sent_mail_array)) {
                        $status=1;
                    }
                }
            }
            return $status;
        }
        public static function getstaff($training_id = 0) {
            $notifying_employee=array();
            $model = self::model()->findbyPK($training_id);
            $sent_mail_array=  explode(',',$model->mail_sent_ids);
            $model_details= HrTrainingDetails::model()->findAll(array('condition' => 'training_id="'. $training_id.'"'));
            foreach ($model_details as $key => $value) {
                if (!in_array($value->employee_id,$sent_mail_array)) {
                    $notifying_employee[]=$value->employee_id;
                }
            }
            return $notifying_employee;
        }
}
