<?php

/**
 * This is the model class for table "{{hr_sale_target_details}}".
 *
 * The followings are the available columns in table '{{hr_sale_target_details}}':
 * @property integer $id
 * @property integer $target_id
 * @property integer $employee_id
 * @property integer $target_card_count
 * @property integer $sold_card_count
 * @property integer $incentive_card_count
 * @property string $incentive_amount
 * @property integer $total_team_leader_amount
 * @property string $target_bonus_amount
 * @property string $days_promotion_15
 * @property string $login_promotion
 * @property string $total_incentive
 * @property string $total_incentive_hold
 * @property string $net_incentive_amount
 */
class HrSaleTargetDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_sale_target_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, target_card_count, net_incentive_amount', 'required'),
			array('target_id, employee_id', 'numerical', 'integerOnly'=>true),
			array('target_card_count, sold_card_count, incentive_card_count,incentive_amount, target_bonus_amount, days_promotion_15, login_promotion, total_incentive, total_incentive_hold,incentive_claw_back,deduction_amount, net_incentive_amount', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, target_id, employee_id, target_card_count, sold_card_count, incentive_card_count, incentive_amount, total_team_leader_amount, target_bonus_amount, days_promotion_15, login_promotion, total_incentive,incentive_claw_back, total_incentive_hold,deduction_amount, net_incentive_amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'targetdetail' => array(self::BELONGS_TO, 'HrSaleTarget', 'target_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'target_id' => 'Target',
			'employee_id' => 'Employee',
			'target_card_count' => 'Target Card Count',
			'sold_card_count' => 'Sold Card Count',
			'incentive_card_count' => 'Incentive Card Count',
			'incentive_amount' => 'Incentive Amount',
			'total_team_leader_amount' => 'Total Login',
			'target_bonus_amount' => 'Target Bonus Amount',
			'days_promotion_15' => 'Days Promotion 15',
			'login_promotion' => 'Login Promotion',
			'total_incentive' => 'Total Incentive',
			'total_incentive_hold' => 'Total Incentive Hold',
			'net_incentive_amount' => 'Net Incentive Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('target_id',$this->target_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('target_card_count',$this->target_card_count,true);
		$criteria->compare('sold_card_count',$this->sold_card_count,true);
		$criteria->compare('incentive_card_count',$this->incentive_card_count,true);
		$criteria->compare('incentive_amount',$this->incentive_amount,true);
		$criteria->compare('total_team_leader_amount',$this->total_team_leader_amount,true);
		$criteria->compare('target_bonus_amount',$this->target_bonus_amount,true);
		$criteria->compare('days_promotion_15',$this->days_promotion_15,true);
		$criteria->compare('login_promotion',$this->login_promotion,true);
		$criteria->compare('total_incentive',$this->total_incentive,true);
		$criteria->compare('total_incentive_hold',$this->total_incentive_hold,true);
		$criteria->compare('net_incentive_amount',$this->net_incentive_amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrSaleTargetDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
