<?php

/**
 * This is the model class for table "{{hr_notification}}".
 *
 * The followings are the available columns in table '{{hr_notification}}':
 * @property integer $id
 * @property string $branch List of branches
 * @property integer $department_id
 * @property integer $employee_id
 * @property string $title  Title of Notification
 * @property string $content
 * @property string $date
 * @property integer $from_user 
 * @property string $designation
 * @property integer $type
 * @property string $displaydate display date
 * @property integer $read_status
 */
class HrNotification extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_notification}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('content,title,branch,employee_id', 'required'),
            array(' type,  from_user', 'numerical', 'integerOnly' => true),
            array('designation, title, branch', 'length', 'max' => 500),
            array('content', 'length', 'max' => 2500),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, department_id, employee_id, content, date, designation, type, read_status', 'safe', 'on' => 'search'),
        );
    }

  

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
             'branches'=>array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'branch'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'department_id' => 'Department',
            'employee_id' => 'Employee',
            'title' => 'Title',
            'content' => 'Content',
            'date' => 'Date',
            'designation' => 'Designation',
            'type' => 'Type',
            'read_status' => 'Read Status',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('department_id', $this->department_id);
        $criteria->compare('emp_id', $this->emp_id);
        $criteria->compare('content', $this->content, true); //
        $criteria->compare('title', $this->title, true); 
        $criteria->compare('date', $this->date, true);
        $criteria->compare('designation', $this->designation, true);
        $criteria->compare('type', $this->type);
        $criteria->compare('read_status', $this->read_status);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return HrNotification the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
