<?php

/**
 * This is the model class for table "{{hr_monthly_salary_component}}".
 *
 * The followings are the available columns in table '{{hr_monthly_salary_component}}':
 * @property integer $id
 * @property integer $branch_id
 * @property integer $employee_id
 * @property integer $salary_month
 * @property integer $salary_year
 * @property integer $salary_type
 * @property string $amount
 * @property string $lock_status
 * @property integer $created_by
 * @property string $created_date_time
 */
class HrMonthlySalaryComponent extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_monthly_salary_component}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
        public $salary_name,$emp_code;
        public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('branch_id, employee_id, salary_month, salary_year,amount', 'required'),
			array('branch_id, employee_id, salary_month, salary_year, salary_type, created_by', 'numerical', 'integerOnly'=>true),
                        array('amount', 'validateamount'),
                        array('salary_type', 'validatesalarycomponent'),
			array('amount', 'length', 'max'=>10),
			array('lock_status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, branch_id, employee_id, salary_month, salary_year, salary_type, amount, lock_status, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}
        public function validatesalarycomponent() {

            if ($this->salary_name!='') {
                $model_salarytype = MasSalarytype::model()->find(array('select' =>'id','condition' =>'salary_name="'.$this->salary_name.'" AND salary_occurence="1" AND isActive ="Y"'));
                $model_salarytype_1 = MasSalarytype::model()->find(array('select' =>'id','condition' =>'salary_name="'.$this->salary_name.'" AND salary_occurence="2" AND isActive ="Y"'));
                 if(!empty($model_salarytype_1)){
                    $this->addError('salary_type', 'Fixed Salary Components cannot be uploaded');
                    $this->rules();
                }else if(empty($model_salarytype)){
                    $this->addError('salary_type', 'Salary Type doesnot exist');
                    $this->rules();
                }else{
                    return true;
                }
            }else{
                $this->addError('salary_type', 'Salary Type cannot be blank');
                $this->rules();
            }

        }
        public function validateamount(){
            if($this->amount < 0){
                $this->addError('amount','Amount must be positive');
                $this->rules();
            }
                return true;
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'branch_sponsor' => array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'branch_id'),
                    'userdetails' => array(self::BELONGS_TO, 'User', 'created_by'),
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'salarytype' => array(self::BELONGS_TO, 'MasSalarytype', 'salary_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'branch_id' => 'Branch',
			'employee_id' => 'Employee',
			'salary_month' => 'Month',
			'salary_year' => 'Year',
			'salary_type' => 'Salary Type',
			'amount' => 'Amount',
			'lock_status' => 'Lock Status',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('branch_id',$this->branch_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('salary_month',$this->salary_month);
		$criteria->compare('salary_year',$this->salary_year);
		$criteria->compare('salary_type',$this->salary_type);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('lock_status',$this->lock_status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrMonthlySalaryComponent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
