<?php

/**
 * This is the model class for table "{{hr_mas_training_course_detail}}".
 *
 * The followings are the available columns in table '{{hr_mas_training_course_detail}}':
 * @property integer $id
 * @property integer $master_id
 * @property string $training_course
 */
class HrMasTrainingCourseDetail extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_mas_training_course_detail}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('training_course', 'required'),
			array('master_id', 'numerical', 'integerOnly'=>true),
			array('training_course', 'length', 'max'=>700),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, master_id, training_course', 'safe', 'on'=>'search'),
		);
	}
         function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 15;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' training course details '.$this->training_course;
        $model_audit_log->save();
    }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'master_id' => 'Master',
			'training_course' => 'Training Course',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('master_id',$this->master_id);
		$criteria->compare('training_course',$this->training_course,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrMasTrainingCourseDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function gettrainingCourse($course_id=0) {
            $condition = 'master_id =  "'.$course_id.'"';
            $model = self::model()->findAll(array('condition' => $condition));
            return CHtml::listData($model, 'id', 'training_course');
        }
        public static function gettrainingmodule($id = 0) {
            $model_details= HrMasTrainingCourseDetail::model()->findByPK($id);
            return $model_details->training_course;
        }
}
