<?php

/**
 * This is the model class for table "{{hr_mas_product}}".
 *
 * The followings are the available columns in table '{{hr_mas_product}}':
 * @property integer $id
 * @property string $product_code
 * @property string $product_name
 * @property string $cost_price
 * @property string $selling_price
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class HrMasProduct extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_mas_product}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_code, product_name, cost_price, selling_price', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('product_code', 'length', 'max'=>255),
                        array('product_code', 'unique'),
			array('product_name', 'length', 'max'=>700),
			array('cost_price, selling_price', 'length', 'max'=>15),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_code, product_name, cost_price, selling_price, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}
        function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 9;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' product '.$this->product_name;
        $model_audit_log->save();
    }


	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_code' => 'Product Code',
			'product_name' => 'Product Name',
			'cost_price' => 'Cost Price',
			'selling_price' => 'Selling Price',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_code',$this->product_code,true);
		$criteria->compare('product_name',$this->product_name,true);
		$criteria->compare('cost_price',$this->cost_price,true);
		$criteria->compare('selling_price',$this->selling_price,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrMasProduct the static model class
	 */
        
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public function getproductdetail() {
            return ($this->product_code. ' '.$this->product_name);
        }
        public static function getProducts() {
            $condition = 'isActive =  "Y"';
            $model = self::model()->findAll(array('condition' => $condition));
            return CHtml::listData($model, 'id', 'productdetail');
        }
}
