<?php

/**
 * This is the model class for table "{{hr_expense}}".
 *
 * The followings are the available columns in table '{{hr_expense}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $expense_description
 * @property integer $duration
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property integer $updated_date_time
 * @property string $isActive
 */
class HrExpense extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_expense}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, expense_description, duration,expense_month,expense_year', 'required'),
			array('employee_id, duration, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('expense_description', 'length', 'max'=>700),
			array('isActive', 'length', 'max'=>1),
           // array('expense_description', 'validateexpense'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, expense_description, duration, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}
        public function validateexpense() {
            if ($this->employee_id!= '' && $this->expense_description!='') {
                $condition='employee_id="'.$this->employee_id.'" and expense_description="'.$this->expense_description.'"';
                if($this->id!=''){
                    $condition.=' AND id!="'.$this->id.'"';
                }
				 $model = self::model()->find(array('condition'=>$condition));
				  if(!empty($model) && $model->id>0){
                    $this->addError('expense_description', 'Expense already exist for this employee.Please edit and update the detail');
                    return false;
                }else{
                    return true;
                }
            }

        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'expense_description' => 'Expense Description',
			'duration' => 'Duration',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('expense_description',$this->expense_description,true);
		$criteria->compare('duration',$this->duration);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrExpense the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function listMonths() {
            $arr_months = array('1'=>'January','2'=>'February','3'=>'March','4'=>'April','5'=>'May','6'=>'June','7'=>'July','8'=>'August','9'=>'September','10'=>'October','11'=>'November','12'=>'December');
            return $arr_months;
       }
}
