<?php

/**
 * This is the model class for table "hr_employee_attendance_punch_break_history".
 *
 * The followings are the available columns in table 'hr_employee_attendance_punch_break_history':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $attendance_date
 * @property integer $punch_time
 * @property string $punch_status
 * @property string $latitude
 * @property string $longitude
 * @property integer $created_by
 * @property string $created_date_time
 */
class HrEmployeePunchBreakHistory extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hr_employee_attendance_punch_break_history';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, attendance_date, punch_time', 'required'),
			array('employee_id, created_by', 'numerical', 'integerOnly'=>true),
			array('punch_status', 'length', 'max'=>1),
			array('latitude, longitude', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, attendance_date, punch_time, punch_status, latitude, longitude, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'attendance_date' => 'Attendance Date',
			'punch_time' => 'Punch Time',
			'punch_status' => 'Punch Status',
			'latitude' => 'Latitude',
			'longitude' => 'Longitude',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('attendance_date',$this->attendance_date);
		$criteria->compare('punch_time',$this->punch_time);
		$criteria->compare('punch_status',$this->punch_status,true);
		$criteria->compare('latitude',$this->latitude,true);
		$criteria->compare('longitude',$this->longitude,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeAttendancePunchBreakHistory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
