<?php

/**
 * This is the model class for table "{{hr_employee_offboard}}".
 *
 * The followings are the available columns in table '{{hr_employee_offboard}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $task
 * @property string $notes
 * @property string $task_done_date
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class HrEmployeeOffboard extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_offboard}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, task_id,task', 'required'),
			array('employee_id,task_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, task, notes, task_done_date, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'taskdetail' => array(self::BELONGS_TO, 'HrMasOffboarding', 'task_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'task' => 'Task',
			'notes' => 'Notes',
			'task_done_date' => 'Task Done Date',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('task',$this->task,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('task_done_date',$this->task_done_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeOffboard the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getemployee($branch_id = 0) {
            $condition = '1=1';
            if ($branch_id > 0) {
                $condition.=' AND branch_or_sponsor_id="' . $branch_id . '"';
            }else{
                if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                    $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
                }
            }
            $SQL = " SELECT * FROM  `erp_hr_employee` E WHERE $condition && id 
                       NOT IN (SELECT  employee_id FROM  erp_hr_employee_offboard)";
            $model = Yii::app()->db->createCommand($SQL)->queryAll();
            $arr_employee = array();
            $employee_details = array();

            foreach ($model as $key => $value) {
                $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d"). ' ' . Yii::app()->controller->ciphertext($value['employee_code'], "d")] = $value['id'];
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['id'] = $id;
                $employee_details[$m]['name'] = Employee::model()->findbyPK($id)->employeefullname;
                $m++;
            }
            return CHtml::listData($employee_details, 'id', 'name');
        }
}
