<?php

/**
 * This is the model class for table "{{hr_employee_leave_migrated}}".
 *
 * The followings are the available columns in table '{{hr_employee_leave_migrated}}':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $leave_type
 * @property string $leave_start_date
 * @property string $leave_end_date
 * @property string $no_days
 * @property string $leave_reason
 * @property integer $ticket_applied
 * @property integer $leave_status
 * @property string $medical_certificate
 * @property string $hr_comment
 * @property string $leave_approval_document
 * @property integer $created_by
 * @property string $created_date_time
 */
class HrEmployeeLeaveMigrated extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_leave_migrated}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, leave_type, leave_start_date, leave_end_date, no_days, leave_reason', 'required'),
			array('employee_id, leave_type, ticket_applied, created_by', 'numerical', 'integerOnly'=>true),
			array('no_days', 'length', 'max'=>5),
			array('leave_status', 'length', 'max'=>1),
                        array('medical_certificate', 'length', 'max'=>500),
			array('leave_approval_document', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, leave_type, leave_start_date, leave_end_date, no_days, leave_reason, ticket_applied, leave_status, medical_certificate, hr_comment, leave_approval_document, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'leavetype' => array(self::BELONGS_TO, 'MasLeave', 'leave_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'leave_type' => 'Leave Type',
			'leave_start_date' => 'Leave Start Date',
			'leave_end_date' => 'Leave End Date',
			'no_days' => 'No Days',
			'leave_reason' => 'Leave Reason',
			'ticket_applied' => 'Ticket Applied',
			'leave_status' => 'Leave Status',
			'medical_certificate' => 'Medical Certificate',
			'hr_comment' => 'Hr Comment',
			'leave_approval_document' => 'Leave Approval Document',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('leave_type',$this->leave_type);
		$criteria->compare('leave_start_date',$this->leave_start_date,true);
		$criteria->compare('leave_end_date',$this->leave_end_date,true);
		$criteria->compare('no_days',$this->no_days,true);
		$criteria->compare('leave_reason',$this->leave_reason,true);
		$criteria->compare('ticket_applied',$this->ticket_applied);
		$criteria->compare('leave_status',$this->leave_status,true);
		$criteria->compare('medical_certificate',$this->medical_certificate,true);
		$criteria->compare('hr_comment',$this->hr_comment,true);
		$criteria->compare('leave_approval_document',$this->leave_approval_document,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeLeaveMigrated the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
