<?php

/**
 * This is the model class for table "{{hr_employee_geocode_history}}".
 *
 * The followings are the available columns in table '{{hr_employee_geocode_history}}':
 * @property integer $id
 * @property integer $geocode_tble_id
 * @property integer $employee_id
 * @property string $latitude
 * @property string $longitude
 * @property string $description
 * @property integer $geo_tble_created_by
 * @property string $geo_tble_created_date_time
 * @property integer $created_by
 * @property string $created_date_time
 */
class HrEmployeeGeocodeHistory extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_geocode_history}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('geocode_tble_id, employee_id', 'required'),
			array('geocode_tble_id, employee_id, geo_tble_created_by, created_by', 'numerical', 'integerOnly'=>true),
			array('latitude, longitude', 'length', 'max'=>200),
			array('description', 'length', 'max'=>300),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, geocode_tble_id, employee_id, latitude, longitude, description, geo_tble_created_by, geo_tble_created_date_time, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'geocode_tble_id' => 'Geocode Tble',
			'employee_id' => 'Employee',
			'latitude' => 'Latitude',
			'longitude' => 'Longitude',
			'description' => 'Description',
			'geo_tble_created_by' => 'Geo Tble Created By',
			'geo_tble_created_date_time' => 'Geo Tble Created Date Time',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('geocode_tble_id',$this->geocode_tble_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('latitude',$this->latitude,true);
		$criteria->compare('longitude',$this->longitude,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('geo_tble_created_by',$this->geo_tble_created_by);
		$criteria->compare('geo_tble_created_date_time',$this->geo_tble_created_date_time,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeGeocodeHistory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
