<?php

/**
 * This is the model class for table "{{hr_employee_geocode}}".
 *
 * The followings are the available columns in table '{{hr_employee_geocode}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $latitude
 * @property string $longitude
 * @property string $created_date_time
 * @property integer $created_by
 */
class HrEmployeeGeocode extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_geocode}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, geocode_location_id', 'required'),
			array('employee_id, created_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, latitude, longitude, created_date_time, created_by', 'safe', 'on'=>'search'),
			//array('latitude', 'validatelatitude'),
			//array('longitude', 'validatelatitude'),
		);
	}
	 public function validatelatitude() {
       if ($this->latitude!= '' && $this->longitude!= '') {
            $condition='(latitude="'.$this->latitude.'" and longitude="'.$this->longitude.'"and employee_id="'.$this->employee_id.'")';
            if($this->id!=''){
                $condition.=' AND id!="'.$this->id.'"';
            }
            $model = self::model()->find(array('condition'=>$condition));
            if(!empty($model) && $model->id>0){
                $this->addError('latitude', 'Latitude/Longitude already exist');
                return false;
            }else{
                return true;
            }
        }
        
    }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			 'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
			 'geolocation_details' => array(self::BELONGS_TO, 'HrMasGeocodeLocation', 'geocode_location_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
                        'geocode_location_id'=>'Geocode Location',
			'latitude' => 'Latitude',
			'longitude' => 'Longitude',
			'created_date_time' => 'Created Date Time',
			'created_by' => 'Created By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('geocode_location_id',$this->geocode_location_id);
		$criteria->compare('latitude',$this->latitude,true);
		$criteria->compare('longitude',$this->longitude,true);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('created_by',$this->created_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeGeocode the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
