<?php

/**
 * This is the model class for table "{{hr_employee_bussiness_trip}}".
 *
 * The followings are the available columns in table '{{hr_employee_bussiness_trip}}':
 * @property integer $id
 * @property integer $function_type
 * @property string $employee_id
 * @property integer $last_approved_level
 * @property integer $last_cancel_level
 * @property string $apply_date
 * @property string $start_date
 * @property string $end_date
 * @property string $no_days
 * @property string $leave_reason
 * @property integer $ticket_applied
 * @property string $travel_date
 * @property string $travel_destination
 * @property string $return_date
 * @property string $return_destination
 * @property integer $status
 * @property integer $approve_level1_id
 * @property string $approve_level1_approved_date
 * @property string $approve_level1_comment
 * @property integer $approve_level2_id
 * @property string $approve_level2_date
 * @property string $approve_level2_comment
 * @property integer $approve_level3_id
 * @property string $approve_level3_date
 * @property string $approve_level3_comment
 * @property integer $approve_level4_id
 * @property string $approve_level4_date
 * @property string $approve_level4_comment
 * @property integer $approve_level5_id
 * @property string $approve_level5_date
 * @property string $approve_level5_comment
 * @property integer $approved_id
 * @property string $approved_date
 * @property string $approval_comment
 * @property integer $status_cancel
 * @property string $cancel_reason_employee
 * @property string $date_apply_cancel
 * @property integer $cancel_level_1_id
 * @property string $date_cancel_level_1
 * @property string $cancel_level_1_comment
 * @property integer $cancel_level_2_id
 * @property string $date_cancel_level_2
 * @property string $cancel_level_2_comment
 * @property integer $cancel_level_3_id
 * @property string $date_cancel_level_3
 * @property string $cancel_level_3_comment
 * @property integer $cancel_level_4_id
 * @property string $date_cancel_level_4
 * @property string $cancel_level_4_comment
 * @property integer $cancel_level_5_id
 * @property string $date_cancel_level_5
 * @property string $cancel_level_5_comment
 * @property integer $cancel_approved_id
 * @property string $date_cancel_hr
 * @property string $cancel_comment_hr
 * @property integer $view_status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class HrEmployeeBussinessTrip extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_bussiness_trip}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, last_approved_level, apply_date, start_date, end_date, no_days, leave_reason', 'required'),
			array('function_type, last_approved_level, last_cancel_level, ticket_applied, status, approve_level1_id, approve_level2_id, approve_level3_id, approve_level4_id, approve_level5_id, approved_id, status_cancel, cancel_level_1_id, cancel_level_2_id, cancel_level_3_id, cancel_level_4_id, cancel_level_5_id, cancel_approved_id, view_status, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('employee_id', 'length', 'max'=>200),
			array('no_days', 'length', 'max'=>5),
			array('travel_destination, return_destination', 'length', 'max'=>700),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, function_type, employee_id, last_approved_level, last_cancel_level, apply_date, start_date, end_date, no_days, leave_reason, ticket_applied, travel_date, travel_destination, return_date, return_destination, status, approve_level1_id, approve_level1_approved_date, approve_level1_comment, approve_level2_id, approve_level2_date, approve_level2_comment, approve_level3_id, approve_level3_date, approve_level3_comment, approve_level4_id, approve_level4_date, approve_level4_comment, approve_level5_id, approve_level5_date, approve_level5_comment, approved_id, approved_date, approval_comment, status_cancel, cancel_reason_employee, date_apply_cancel, cancel_level_1_id, date_cancel_level_1, cancel_level_1_comment, cancel_level_2_id, date_cancel_level_2, cancel_level_2_comment, cancel_level_3_id, date_cancel_level_3, cancel_level_3_comment, cancel_level_4_id, date_cancel_level_4, cancel_level_4_comment, cancel_level_5_id, date_cancel_level_5, cancel_level_5_comment, cancel_approved_id, date_cancel_hr, cancel_comment_hr, view_status, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'function_type' => 'Function Type',
			'employee_id' => 'Employee',
			'last_approved_level' => 'Last Approved Level',
			'last_cancel_level' => 'Last Cancel Level',
			'apply_date' => 'Apply Date',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'no_days' => 'No Days',
			'leave_reason' => 'Leave Reason',
			'ticket_applied' => 'Ticket Applied',
			'travel_date' => 'Travel Date',
			'travel_destination' => 'Travel Destination',
			'return_date' => 'Return Date',
			'return_destination' => 'Return Destination',
			'status' => 'Status',
			'approve_level1_id' => 'Approve Level1',
			'approve_level1_approved_date' => 'Approve Level1 Approved Date',
			'approve_level1_comment' => 'Approve Level1 Comment',
			'approve_level2_id' => 'Approve Level2',
			'approve_level2_date' => 'Approve Level2 Date',
			'approve_level2_comment' => 'Approve Level2 Comment',
			'approve_level3_id' => 'Approve Level3',
			'approve_level3_date' => 'Approve Level3 Date',
			'approve_level3_comment' => 'Approve Level3 Comment',
			'approve_level4_id' => 'Approve Level4',
			'approve_level4_date' => 'Approve Level4 Date',
			'approve_level4_comment' => 'Approve Level4 Comment',
			'approve_level5_id' => 'Approve Level5',
			'approve_level5_date' => 'Approve Level5 Date',
			'approve_level5_comment' => 'Approve Level5 Comment',
			'approved_id' => 'Approved',
			'approved_date' => 'Approved Date',
			'approval_comment' => 'Approval Comment',
			'status_cancel' => 'Status Cancel',
			'cancel_reason_employee' => 'Cancel Reason Employee',
			'date_apply_cancel' => 'Date Apply Cancel',
			'cancel_level_1_id' => 'Cancel Level 1',
			'date_cancel_level_1' => 'Date Cancel Level 1',
			'cancel_level_1_comment' => 'Cancel Level 1 Comment',
			'cancel_level_2_id' => 'Cancel Level 2',
			'date_cancel_level_2' => 'Date Cancel Level 2',
			'cancel_level_2_comment' => 'Cancel Level 2 Comment',
			'cancel_level_3_id' => 'Cancel Level 3',
			'date_cancel_level_3' => 'Date Cancel Level 3',
			'cancel_level_3_comment' => 'Cancel Level 3 Comment',
			'cancel_level_4_id' => 'Cancel Level 4',
			'date_cancel_level_4' => 'Date Cancel Level 4',
			'cancel_level_4_comment' => 'Cancel Level 4 Comment',
			'cancel_level_5_id' => 'Cancel Level 5',
			'date_cancel_level_5' => 'Date Cancel Level 5',
			'cancel_level_5_comment' => 'Cancel Level 5 Comment',
			'cancel_approved_id' => 'Cancel Approved',
			'date_cancel_hr' => 'Date Cancel Hr',
			'cancel_comment_hr' => 'Cancel Comment Hr',
			'view_status' => '0-Not viewed,1-Viewed',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('function_type',$this->function_type);
		$criteria->compare('employee_id',$this->employee_id,true);
		$criteria->compare('last_approved_level',$this->last_approved_level);
		$criteria->compare('last_cancel_level',$this->last_cancel_level);
		$criteria->compare('apply_date',$this->apply_date,true);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('no_days',$this->no_days,true);
		$criteria->compare('leave_reason',$this->leave_reason,true);
		$criteria->compare('ticket_applied',$this->ticket_applied);
		$criteria->compare('travel_date',$this->travel_date,true);
		$criteria->compare('travel_destination',$this->travel_destination,true);
		$criteria->compare('return_date',$this->return_date,true);
		$criteria->compare('return_destination',$this->return_destination,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('approve_level1_id',$this->approve_level1_id);
		$criteria->compare('approve_level1_approved_date',$this->approve_level1_approved_date,true);
		$criteria->compare('approve_level1_comment',$this->approve_level1_comment,true);
		$criteria->compare('approve_level2_id',$this->approve_level2_id);
		$criteria->compare('approve_level2_date',$this->approve_level2_date,true);
		$criteria->compare('approve_level2_comment',$this->approve_level2_comment,true);
		$criteria->compare('approve_level3_id',$this->approve_level3_id);
		$criteria->compare('approve_level3_date',$this->approve_level3_date,true);
		$criteria->compare('approve_level3_comment',$this->approve_level3_comment,true);
		$criteria->compare('approve_level4_id',$this->approve_level4_id);
		$criteria->compare('approve_level4_date',$this->approve_level4_date,true);
		$criteria->compare('approve_level4_comment',$this->approve_level4_comment,true);
		$criteria->compare('approve_level5_id',$this->approve_level5_id);
		$criteria->compare('approve_level5_date',$this->approve_level5_date,true);
		$criteria->compare('approve_level5_comment',$this->approve_level5_comment,true);
		$criteria->compare('approved_id',$this->approved_id);
		$criteria->compare('approved_date',$this->approved_date,true);
		$criteria->compare('approval_comment',$this->approval_comment,true);
		$criteria->compare('status_cancel',$this->status_cancel);
		$criteria->compare('cancel_reason_employee',$this->cancel_reason_employee,true);
		$criteria->compare('date_apply_cancel',$this->date_apply_cancel,true);
		$criteria->compare('cancel_level_1_id',$this->cancel_level_1_id);
		$criteria->compare('date_cancel_level_1',$this->date_cancel_level_1,true);
		$criteria->compare('cancel_level_1_comment',$this->cancel_level_1_comment,true);
		$criteria->compare('cancel_level_2_id',$this->cancel_level_2_id);
		$criteria->compare('date_cancel_level_2',$this->date_cancel_level_2,true);
		$criteria->compare('cancel_level_2_comment',$this->cancel_level_2_comment,true);
		$criteria->compare('cancel_level_3_id',$this->cancel_level_3_id);
		$criteria->compare('date_cancel_level_3',$this->date_cancel_level_3,true);
		$criteria->compare('cancel_level_3_comment',$this->cancel_level_3_comment,true);
		$criteria->compare('cancel_level_4_id',$this->cancel_level_4_id);
		$criteria->compare('date_cancel_level_4',$this->date_cancel_level_4,true);
		$criteria->compare('cancel_level_4_comment',$this->cancel_level_4_comment,true);
		$criteria->compare('cancel_level_5_id',$this->cancel_level_5_id);
		$criteria->compare('date_cancel_level_5',$this->date_cancel_level_5,true);
		$criteria->compare('cancel_level_5_comment',$this->cancel_level_5_comment,true);
		$criteria->compare('cancel_approved_id',$this->cancel_approved_id);
		$criteria->compare('date_cancel_hr',$this->date_cancel_hr,true);
		$criteria->compare('cancel_comment_hr',$this->cancel_comment_hr,true);
		$criteria->compare('view_status',$this->view_status);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeBussinessTrip the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
