<?php

/**
 * This is the model class for table "{{hr_employee_attendance_excuse}}".
 *
 * The followings are the available columns in table '{{hr_employee_attendance_excuse}}':
 * @property integer $id
 * @property integer $function_type
 * @property integer $last_approved_level
 * @property integer $employee_id
 * @property string $apply_date
 * @property integer $status
 * @property integer $approve_level1_id
 * @property string $approve_level1_date
 * @property string $approve_level1_comment
 * @property integer $approve_level2_id
 * @property string $approve_level2_date
 * @property string $approve_level2_comment
 * @property integer $approve_level3_id
 * @property string $approve_level3_date
 * @property string $approve_level3_comment
 * @property integer $approve_level4_id
 * @property string $approve_level4_date
 * @property string $approve_level4_comment
 * @property integer $approve_level5_id
 * @property string $approve_level5_date
 * @property string $approve_level5_comment
 * @property integer $approved_by
 * @property string $approved_date
 * @property string $approval_comment
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class HrEmployeeAttendanceExcuse extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_attendance_excuse}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('last_approved_level, employee_id, apply_date', 'required'),
			array('function_type, last_approved_level, employee_id, status, approve_level1_id, approve_level2_id, approve_level3_id, approve_level4_id, approve_level5_id, approved_by, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('function_type', 'validatefunctiontype'),
                        // The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, function_type, last_approved_level, employee_id, apply_date, status, approve_level1_id, approve_level1_date, approve_level1_comment, approve_level2_id, approve_level2_date, approve_level2_comment, approve_level3_id, approve_level3_date, approve_level3_comment, approve_level4_id, approve_level4_date, approve_level4_comment, approve_level5_id, approve_level5_date, approve_level5_comment, approved_by, approved_date, approval_comment, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}
        public function validatefunctiontype() {
            if ($this->function_type == '' && $this->employee_id>0) {
                $this->addError('function_type', 'Approval level missing.Contact HR');
                $this->rules();
            }
            return true;
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'approvelevel' => array(self::BELONGS_TO, 'HrEmployeeApproveLevel', 'function_type'),
                    'level1' => array(self::BELONGS_TO, 'Employee', 'approve_level1_id'),
                    'level2' => array(self::BELONGS_TO, 'Employee', 'approve_level2_id'),
                    'level3' => array(self::BELONGS_TO, 'Employee', 'approve_level3_id'),
                    'level4' => array(self::BELONGS_TO, 'Employee', 'approve_level4_id'),
                    'level5' => array(self::BELONGS_TO, 'Employee', 'approve_level5_id'),
                    'finalapprove' => array(self::BELONGS_TO, 'Employee', 'approved_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'function_type' => 'Function Type',
			'last_approved_level' => 'Last Approved Level',
			'employee_id' => 'Employee',
			'apply_date' => 'Apply Date',
			'status' => 'Status',
			'approve_level1_id' => 'Approve Level1',
			'approve_level1_date' => 'Approve Level1 Date',
			'approve_level1_comment' => 'Approve Level1 Comment',
			'approve_level2_id' => 'Approve Level2',
			'approve_level2_date' => 'Approve Level2 Date',
			'approve_level2_comment' => 'Approve Level2 Comment',
			'approve_level3_id' => 'Approve Level3',
			'approve_level3_date' => 'Approve Level3 Date',
			'approve_level3_comment' => 'Approve Level3 Comment',
			'approve_level4_id' => 'Approve Level4',
			'approve_level4_date' => 'Approve Level4 Date',
			'approve_level4_comment' => 'Approve Level4 Comment',
			'approve_level5_id' => 'Approve Level5',
			'approve_level5_date' => 'Approve Level5 Date',
			'approve_level5_comment' => 'Approve Level5 Comment',
			'approved_by' => 'Approved By',
			'approved_date' => 'Approved Date',
			'approval_comment' => 'Approval Comment',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('function_type',$this->function_type);
		$criteria->compare('last_approved_level',$this->last_approved_level);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('apply_date',$this->apply_date,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('approve_level1_id',$this->approve_level1_id);
		$criteria->compare('approve_level1_date',$this->approve_level1_date,true);
		$criteria->compare('approve_level1_comment',$this->approve_level1_comment,true);
		$criteria->compare('approve_level2_id',$this->approve_level2_id);
		$criteria->compare('approve_level2_date',$this->approve_level2_date,true);
		$criteria->compare('approve_level2_comment',$this->approve_level2_comment,true);
		$criteria->compare('approve_level3_id',$this->approve_level3_id);
		$criteria->compare('approve_level3_date',$this->approve_level3_date,true);
		$criteria->compare('approve_level3_comment',$this->approve_level3_comment,true);
		$criteria->compare('approve_level4_id',$this->approve_level4_id);
		$criteria->compare('approve_level4_date',$this->approve_level4_date,true);
		$criteria->compare('approve_level4_comment',$this->approve_level4_comment,true);
		$criteria->compare('approve_level5_id',$this->approve_level5_id);
		$criteria->compare('approve_level5_date',$this->approve_level5_date,true);
		$criteria->compare('approve_level5_comment',$this->approve_level5_comment,true);
		$criteria->compare('approved_by',$this->approved_by);
		$criteria->compare('approved_date',$this->approved_date,true);
		$criteria->compare('approval_comment',$this->approval_comment,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeAttendanceExcuse the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getStatus($id) {
            switch ($id) {
                case 0:
                    $status = "Saved";
                    break;
                case 1:
                    $status = "Applied";
                    break;
                case 2:
                    $status = "Level 1 Confirmed";
                    break;
                case 3:
                    $status = "Level 1 Rejected";
                    break;
                case 4:
                    $status = "Level 2 Confirmed";
                    break;
                case 5:
                    $status = "Level 2 Rejected";
                    break;
                case 6:
                    $status = "Level 3 Confirmed";
                    break;
                case 7:
                    $status = "Level 3 Rejected";
                    break;
                case 8:
                    $status = "Level 4 Confirmed";
                    break;
                case 9:
                    $status = "Level 4 Rejected";
                    break;
                case 10:
                    $status = "Level 5 Confirmed";
                    break;
                case 11:
                    $status = "Level 5 Rejected";
                    break;
                case 12:
                    $status = "Approved";
                    break;
                case 13:
                    $status = "Rejected";
                    break;
            }
            return $status;
        }
    public static function getPendingapproval($branch, $from) {
        $condition = 'status>0 AND employeedetail.isActive="Y" AND last_approved_level<t.max_level';
        if ($branch > 0) {
            $condition .= ' AND employeedetail.branch_or_sponsor_id="' . $branch . '"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        $model_details = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $arr_id = array();
        $excuse_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->status != 3 && $value->status != 5 && $value->status != 7 && $value->status != 9 && $value->status != 11) {
                if($value->status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && $value->approvelevel->level_1_type == 'H' && $value->approvelevel->level_1_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && $value->approvelevel->level_2_type == 'H' && $value->approvelevel->level_2_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && $value->approvelevel->level_3_type == 'H' && $value->approvelevel->level_3_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && $value->approvelevel->level_4_type == 'H' && $value->approvelevel->level_4_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && $value->approvelevel->level_5_type == 'H' && $value->approvelevel->level_5_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $excuse_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $excuse_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }

    public static function getintermediateapproval($employee_id, $from) {
        $model_details = self::model()->with('employeedetail', 'approvelevel')->findAll(array('condition' => 'employeedetail.isActive="Y" AND last_approved_level<t.max_level AND status>0'));
        $arr_id = array();
        $excuse_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->status != 3 && $value->status != 5 && $value->status != 7 && $value->status != 9 && $value->status != 11) {
                if($value->status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $excuse_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $excuse_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }
    public static function getEmployeeList() {
        $user_id = Yii::app()->user->id; 
		$modelemployee = User::model()->findByPK($user_id);
		$employee_id = $modelemployee->employee_id;
        $condition = 'employeedetail.isActive="Y" AND (status="12" OR status="13") AND(approve_level1_id="'.$employee_id.'" OR approve_level2_id="'.$employee_id.'" OR approve_level3_id="'.$employee_id.'" OR approve_level4_id="'.$employee_id.'" OR approve_level5_id="'.$employee_id.'" OR approved_by="'.$employee_id.'")';
        $model = self::model()->with('employeedetail')->findAll(array('condition' => $condition, 'group' => 'employee_id'));
        return CHtml::listData($model, 'employee_id', 'employeedetail.employeefullname');
    }
}
