<?php

/**
 * This is the model class for table "{{hr_employee_approve_level}}".
 *
 * The followings are the available columns in table '{{hr_employee_approve_level}}':
 * @property integer $id
 * @property integer $functionality_id
 * @property integer $employee_id
 * @property integer $max_level
 * @property string $level_1_type
 * @property string $level_2_type
 * @property string $level_3_type
 * @property string $level_4_type
 * @property string $level_5_type
 * @property integer $level_1_authority
 * @property integer $level_2_authority
 * @property integer $level_3_authority
 * @property integer $level_4_authority
 * @property integer $level_5_authority
 */
class HrEmployeeApproveLevel extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_approve_level}}';
	}
        public $line_manager;
        public $supervisor;
        public $functionality_name;
        /**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('functionality_id, employee_id, max_level', 'required'),
			array('functionality_id, employee_id, max_level, level_1_authority, level_2_authority, level_3_authority, level_4_authority, level_5_authority', 'numerical', 'integerOnly'=>true),
			array('level_1_type, level_2_type, level_3_type, level_4_type, level_5_type', 'length', 'max'=>1),
                        array('max_level', 'validatelevelapproval'),
                        array('max_level', 'validatedocumentlevel'),
                        array('max_level', 'validateDuplicateAuthority'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, functionality_id, employee_id, max_level, level_1_type, level_2_type, level_3_type, level_4_type, level_5_type, level_1_authority, level_2_authority, level_3_authority, level_4_authority, level_5_authority', 'safe', 'on'=>'search'),
		);
	}
       
        public function validateDuplicateAuthority()
        {
            if($this->max_level>0 && $this->employee_id>0){
                $maxLevel = $this->max_level; // Set the maximum level
                $authorityValues = [];
                $hasDuplicates = false;
                for ($level = 1; $level <= $maxLevel; $level++) {
                    $value = $this->{'level_' . $level . '_authority'};
                    if (!empty($value)) {
                        if (isset($authorityValues[$value])) {
                            $this->addError('level_' . $level . '_authority', 'Duplicate entry found in level ' . $level . ' of '.$this->employeedetail->employeefullname);
                            $hasDuplicates = true;
                        } else {
                            $authorityValues[$value] = true;
                        }
                    }
                }
                return !$hasDuplicates;
            }else if($this->max_level>0 && $this->employee_id==0){
                $maxLevel = $this->max_level; // Set the maximum level
                $authorityValues = [];
                $hasDuplicates = false;
                for ($level = 1; $level <= $maxLevel; $level++) {
                    $value = $this->{'level_' . $level . '_authority'};
                    if (!empty($value)) {
                        if (isset($authorityValues[$value])) {
                            $this->addError('level_' . $level . '_authority', 'Duplicate entry found in level ' . $level.' of '.$this->functionalitydetail->functionality);
                            $hasDuplicates = true;
                        } else {
                            $authorityValues[$value] = true;
                        }
                    }
                }
                return !$hasDuplicates;
            }
            else{
                if($this->max_level==0){
                    $this->addError('max_level', 'Level Must be Greater than 0');
                        return false;
                }else{
                    return true;
                }
            }
        }
        public function validatedocumentlevel() {
            if($this->max_level != '' && $this->functionality_id==4) {
                if($this->max_level==1){
                    if ($this->level_1_type!='H') {
                        $this->addError('level_1_type', 'Select Final Level as Admin to Issue Document');
                        return false;
                    }
                }else if($this->max_level==2){
                    if ($this->level_2_type!='H') {
                        $this->addError('level_2_type', 'Select Final Level as Admin to Issue Document');
                        return false;
                    }
                }else if($this->max_level==3){
                    if ($this->level_3_type!='H') {
                        $this->addError('level_3_type', 'Select Final Level as Admin to Issue Document');
                        return false;
                    }
                }else if($this->max_level==4){
                    if ($this->level_4_type!='H') {
                        $this->addError('level_4_type', 'Select Final Level as Admin to Issue Document');
                        return false;
                    }
                }else if($this->max_level==5){
                    if ($this->level_5_type!='H') {
                        $this->addError('level_5_type', 'Select Final Level as Admin to Issue Document');
                        return false;
                    }
                }
            }
        }
        public function validatelevelapproval() {
            if($this->max_level != '') {
                if($this->max_level==1){
                    if ($this->level_1_type=='') {
                        $this->addError('level_1_type', 'Select Level 1 Type');
                        return false;
                    }else if ($this->level_1_authority=='' || $this->level_1_authority==0) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==2){
                    if ($this->level_1_type=='') {
                        $this->addError('level_1_type', 'Select Level 1 Type');
                        return false;
                    }else if ($this->functionality_id!=6 &&($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_type=='') {
                        $this->addError('level_2_type', 'Select Level 2 Type');
                        return false;
                    }else if ($this->level_2_authority=='' || $this->level_2_authority==0) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==3){
                    if ($this->level_1_type=='') {
                        $this->addError('level_1_type', 'Select Level 1 Type');
                        return false;
                    }else if ($this->functionality_id!=6 &&($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_type=='') {
                        $this->addError('level_2_type', 'Select Level 2 Type');
                        return false;
                    }else if ($this->level_2_authority=='' || $this->level_2_authority==0) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else if ($this->level_3_type=='') {
                        $this->addError('level_3_type', 'Select Level 3 Type');
                        return false;
                    }else if ($this->level_3_authority=='' || $this->level_3_authority==0) {
                        $this->addError('level_3_authority', 'Select Level 3 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==4){
                    if ($this->level_1_type=='') {
                        $this->addError('level_1_type', 'Select Level 1 Type');
                        return false;
                    }else if ($this->functionality_id!=6 && ($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_type=='') {
                        $this->addError('level_2_type', 'Select Level 2 Type');
                        return false;
                    }else if ($this->level_2_authority=='' || $this->level_2_authority==0) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else if ($this->level_3_type=='') {
                        $this->addError('level_3_type', 'Select Level 3 Type');
                        return false;
                    }else if ($this->level_3_authority=='' || $this->level_3_authority==0) {
                        $this->addError('level_3_authority', 'Select Level 3 Authority');
                        return false;
                    }else if ($this->level_4_type=='') {
                        $this->addError('level_4_type', 'Select Level 4 Type');
                        return false;
                    }else if ($this->level_4_authority=='' || $this->level_4_authority==0) {
                        $this->addError('level_4_authority', 'Select Level 4 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==5){
                    if ($this->level_1_type=='') {
                        $this->addError('level_1_type', 'Select Level 1 Type');
                        return false;
                    }else if ($this->functionality_id!=6 && ($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_type=='') {
                        $this->addError('level_2_type', 'Select Level 2 Type');
                        return false;
                    }else if ($this->level_2_authority=='' || $this->level_2_authority==0) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else if ($this->level_3_type=='') {
                        $this->addError('level_3_type', 'Select Level 3 Type');
                        return false;
                    }else if ($this->level_3_authority=='' || $this->level_3_authority==0) {
                        $this->addError('level_3_authority', 'Select Level 3 Authority');
                        return false;
                    }else if ($this->level_4_type=='') {
                        $this->addError('level_4_type', 'Select Level 4 Type');
                        return false;
                    }else if ($this->level_4_authority=='' || $this->level_4_authority==0) {
                        $this->addError('level_4_authority', 'Select Level 4 Authority');
                        return false;
                    }else if ($this->level_5_type=='') {
                        $this->addError('level_5_type', 'Select Level 5 Type');
                        return false;
                    }else if ($this->level_5_authority=='' || $this->level_5_authority==0) {
                        $this->addError('level_5_authority', 'Select Level 5 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }
            }
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'functionalitydetail' => array(self::BELONGS_TO, 'HrMasterFunction', 'functionality_id'),
                    'level1details' => array(self::BELONGS_TO, 'Employee', 'level_1_authority'),
                    'level2details' => array(self::BELONGS_TO, 'Employee', 'level_2_authority'),
                    'level3details' => array(self::BELONGS_TO, 'Employee', 'level_3_authority'),
                    'level4details' => array(self::BELONGS_TO, 'Employee', 'level_4_authority'),
                    'level5details' => array(self::BELONGS_TO, 'Employee', 'level_5_authority'),

		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'functionality_id' => 'Functionality',
			'employee_id' => 'Employee',
			'max_level' => 'Max Level',
			'level_1_type' => 'Level 1 Type',
			'level_2_type' => 'Level 2 Type',
			'level_3_type' => 'Level 3 Type',
			'level_4_type' => 'Level 4 Type',
			'level_5_type' => 'Level 5 Type',
			'level_1_authority' => 'Level 1 Authority',
			'level_2_authority' => 'Level 2 Authority',
			'level_3_authority' => 'Level 3 Authority',
			'level_4_authority' => 'Level 4 Authority',
			'level_5_authority' => 'Level 5 Authority',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('functionality_id',$this->functionality_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('max_level',$this->max_level);
		$criteria->compare('level_1_type',$this->level_1_type,true);
		$criteria->compare('level_2_type',$this->level_2_type,true);
		$criteria->compare('level_3_type',$this->level_3_type,true);
		$criteria->compare('level_4_type',$this->level_4_type,true);
		$criteria->compare('level_5_type',$this->level_5_type,true);
		$criteria->compare('level_1_authority',$this->level_1_authority);
		$criteria->compare('level_2_authority',$this->level_2_authority);
		$criteria->compare('level_3_authority',$this->level_3_authority);
		$criteria->compare('level_4_authority',$this->level_4_authority);
		$criteria->compare('level_5_authority',$this->level_5_authority);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeApproveLevel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getmailid($id,$level) {
            $employee_id=0;
            $model = self::model()->findbyPK($id);
            if($level==1){
                $employee_id=$model->level_1_authority;
            }else if($level==2){
                $employee_id=$model->level_2_authority;
            }else if($level==3){
                $employee_id=$model->level_3_authority;
            }else if($level==4){
                $employee_id=$model->level_4_authority;
            }else if($level==5){
                $employee_id=$model->level_5_authority;
            }
            return $employee_id;
        }
        public static function getleveltype($id,$level) {
            $approval_login='';
            $arr_login=array('N'=>'ADM','L'=>'ESS','S'=>'ESS','N'=>'ESS');
            $model = self::model()->findbyPK($id);
            if($level==1){
                $approval_login=$arr_login[$model->level_1_type];
            }else if($level==2){
                $approval_login=$arr_login[$model->level_2_type];
            }else if($level==3){
                $approval_login=$arr_login[$model->level_3_type];
            }else if($level==4){
                $approval_login=$arr_login[$model->level_4_type];
            }else if($level==5){
                $approval_login=$arr_login[$model->level_5_type];
            }
            return $approval_login;
        }
}
