<?php

/**
 * This is the model class for table "{{hr_appraisal}}".
 *
 * The followings are the available columns in table '{{hr_appraisal}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $appraisal_for
 * @property string $appraisal_description
 * @property integer $reporting_manager
 * @property string $reporting_description
 * @property integer $hr_id
 * @property string $hr_description
 * @property integer $hr_rating
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class HrAppraisal extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_appraisal}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('employee_id, appraisal_for', 'required'),
            array('function_type,last_approved_level,employee_id,status,created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('function_type', 'validatefunctiontype'),
            array('appraisal_for', 'length', 'max' => 700),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            //array('employee_id','unique'),
            //array('employee_id', 'validateapraisal'),
            array('id, employee_id, appraisal_for, appraisal_description, revert_comment,created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    public function validatefunctiontype() {
        if ($this->function_type == '') {
            $this->addError('function_type', 'Approval level missing.Contact HR');
            $this->rules();
        }
        return true;
    }

    public function validateapraisal() {
        if ($this->employee_id != '' && $this->appraisal_for != '') {
            $condition = 'employee_id="' . $this->employee_id . '" and appraisal_for = "' . $this->appraisal_for . '"';
            if ($this->id != '') {
                $condition .= ' AND id!="' . $this->id . '"';
            }
            $model = self::model()->find(array('condition' => $condition));
            if ($model->id > 0) {
                $this->addError('employee_id', 'Appraisal Already exists');
                return false;
            } else {
                return true;
            }
        }
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
            'approvelevel' => array(self::BELONGS_TO, 'HrEmployeeApproveLevel', 'function_type'),
            'level1' => array(self::BELONGS_TO, 'Employee', 'approve_level1_id'),
            'level2' => array(self::BELONGS_TO, 'Employee', 'approve_level2_id'),
            'level3' => array(self::BELONGS_TO, 'Employee', 'approve_level3_id'),
            'level4' => array(self::BELONGS_TO, 'Employee', 'approve_level4_id'),
            'level5' => array(self::BELONGS_TO, 'Employee', 'approve_level5_id'),
            'finalapprove' => array(self::BELONGS_TO, 'Employee', 'approved_by'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'employee_id' => 'Employee',
            'appraisal_for' => 'Appraisal For',
            'appraisal_description' => 'Appraisal Description',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'revert_comment' => 'Reason',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('employee_id', $this->employee_id);
        $criteria->compare('appraisal_for', $this->appraisal_for, true);
        $criteria->compare('appraisal_description', $this->appraisal_description, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return HrAppraisal the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getStatus($id) {
        switch ($id) {
            case 1:
                $status = "Added";
                break;
            case 2:
                $status = "Level 1 Pending";
                break;
            case 3:
                $status = "Level 1 Completed";
                break;
            case 4:
                $status = "Level 2 Pending";
                break;
            case 5:
                $status = "Level 2 Completed";
                break;
            case 6:
                $status = "Level 3 Pending";
                break;
            case 7:
                $status = "Level 3 Completed";
                break;
            case 8:
                $status = "Level 4 Pending";
                break;
            case 9:
                $status = "Level 4 Completed";
                break;
            case 10:
                $status = "Level 5 Pending";
                break;
            case 11:
                $status = "Level 5 Completed";
                break;
            case 12:
                $status = "Reviewed";
                break;
            case -3:
                $status = "Added";
                break;
            case -2:
                $status = "Line Manager Approval Pending";
                break;
            case -1:
                $status = "Line Manager Approved";
                break;
            default:
                $status = "Added";
        }
        return $status;
    }

    public static function getPendingapproval($branch, $from) {
        $condition = '1=1';
        if ($branch > 0) {
            $condition .= ' AND employeedetail.branch_or_sponsor_id="' . $branch . '"';
        }
        $model_details = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee = $model_user->hr_connected_employee_id;
        $arr_id = array();
        $appraisal_id = 0;
        foreach ($model_details as $key => $value) {
            //if ($value->status != 2 && $value->status != 4 && $value->status != 6 && $value->status != 8 && $value->status != 10) {
            if ($value->status < 12) {
                $last_approved_level = $value->last_approved_level;
                $next_approval_level = $last_approved_level + 1;
                if ($next_approval_level <= $value->max_level) {
                    if ($next_approval_level == 1 && $value->approvelevel->level_1_type == 'H' && $value->approvelevel->level_1_authority == $hr_connected_employee) {
                        $arr_id[] = $value->id;
                    } else if ($next_approval_level == 2 && $value->approvelevel->level_2_type == 'H' && $value->approvelevel->level_2_authority == $hr_connected_employee) {
                        $arr_id[] = $value->id;
                    } else if ($next_approval_level == 3 && $value->approvelevel->level_3_type == 'H' && $value->approvelevel->level_3_authority == $hr_connected_employee) {
                        $arr_id[] = $value->id;
                    } else if ($next_approval_level == 4 && $value->approvelevel->level_4_type == 'H' && $value->approvelevel->level_4_authority == $hr_connected_employee) {
                        $arr_id[] = $value->id;
                    } else if ($next_approval_level == 5 && $value->approvelevel->level_5_type == 'H' && $value->approvelevel->level_5_authority == $hr_connected_employee) {
                        $arr_id[] = $value->id;
                    }
                }
            }
            //}
        }
        if (!empty($arr_id)) {
            $appraisal_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $appraisal_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }

    public static function getintermediateapproval($employee_id, $from) {
        $model_details = self::model()->with('employeedetail', 'approvelevel')->findAll(array('condition' => 'employeedetail.isActive="Y" AND last_approved_level<t.max_level'));
        $arr_id = array();
        $appraisal_id = 0;
        foreach ($model_details as $key => $value) {
            //if ($value->status != 2 && $value->status != 4 && $value->status != 6 && $value->status != 8 && $value->status != 10) {
            if ($value->status < 12) {
                $last_approved_level = $value->last_approved_level;
                $next_approval_level = $last_approved_level + 1;
                if ($next_approval_level <= $value->max_level) {
                    if ($next_approval_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                        $arr_id[] = $value->id;
                    } else if ($next_approval_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                        $arr_id[] = $value->id;
                    } else if ($next_approval_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                        $arr_id[] = $value->id;
                    } else if ($next_approval_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                        $arr_id[] = $value->id;
                    } else if ($next_approval_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                        $arr_id[] = $value->id;
                    }
                }
            }
            //}
        }
        if (!empty($arr_id)) {
            $appraisal_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $appraisal_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }

    public static function listYears($less, $high) {
        $arr_years = array();
        $cur_year = date("Y");
        $start_year = $cur_year - $less;
        $end_year = $cur_year + $high;
        for ($i = $start_year; $i <= $end_year; $i++) {
            $arr_years[$i . " - Year End Appraisal"] = $i . " - Year End Appraisal";
        }
        return $arr_years;
    }

    public static function getcurrentapprovallevel($id) {
        $level = 0;
        if ($id > 0) {
            $model = self::model()->findbypk($id);
            if ($model->approve_level1_date != '0000-00-00') {
                $level++;
            }
            if ($model->approve_level2_date != '0000-00-00') {
                $level++;
            }
            if ($model->approve_level3_date != '0000-00-00') {
                $level++;
            }
            if ($model->approve_level4_date != '0000-00-00') {
                $level++;
            }
            if ($model->approve_level5_date != '0000-00-00') {
                $level++;
            }
            if ($model->approved_date != '0000-00-00') {
                $level++;
            }
        }
        return $level;
    }

}
