<?php

/**
 * This is the model class for table "{{hr_eos_gratuity_details}}".
 *
 * The followings are the available columns in table '{{hr_eos_gratuity_details}}':
 * @property integer $id
 * @property integer $eos_id
 * @property integer $employee_id
 * @property integer $gratuity_mas_id
 * @property string $payment_period
 * @property string $amount
 */
class EosGratuityDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_eos_gratuity_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('eos_id, employee_id, gratuity_mas_id, payment_period, amount', 'required'),
			array('eos_id, employee_id, gratuity_mas_id', 'numerical', 'integerOnly'=>true),
			array('payment_period', 'length', 'max'=>500),
			array('amount', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, eos_id, employee_id, gratuity_mas_id, payment_period, amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'mastergrauity'=>array(self::BELONGS_TO, 'MasGratuity', 'gratuity_mas_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'eos_id' => 'Eos',
			'employee_id' => 'Employee',
			'gratuity_mas_id' => 'Gratuity Mas',
			'payment_period' => 'Payment Period',
			'amount' => 'Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('eos_id',$this->eos_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('gratuity_mas_id',$this->gratuity_mas_id);
		$criteria->compare('payment_period',$this->payment_period,true);
		$criteria->compare('amount',$this->amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EosGratuityDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
