<?php
class EmployeewpsCompany extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_employee_wps_company}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('wps_company_id,employee_id', 'required'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,wps_company_id,employee_id,created_by,created_datetime,updated_by,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
             'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
             'companydetail' => array(self::BELONGS_TO, 'MasCompanyWpsDetails', 'wps_company_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'employee_id' => 'Employee Name',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {

        $criteria=new CDbCriteria;
        $criteria->with = array('employeedetail');
        $sterm = trim(Yii::app()->request->getParam('search'));
        if($sterm)
        {
          $criteria->addCondition('employeedetail.first_name like "%' . $sterm . '%"', 'AND');
        }
    
        $criteria->compare('id',$this->id);
        $criteria->compare('employee_id',$this->employee_id,true);

        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'employeedetail.first_name ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return  the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

   
}
