<?php

/**
 * This is the model class for table "{{hr_employee_ticket}}".
 *
 * The followings are the available columns in table '{{hr_employee_ticket}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $payment_date
 * @property string $ticket_amt
 * @property integer $payment_mode
 * @property integer $year
 * @property string $created_date_time
 * @property integer $created_by
 * @property string $updated_date_time
 * @property integer $updated_by
 */
class EmployeeTicket extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_ticket}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id,leave_type,year,status', 'required'),
			array('employee_id, payment_mode, year, created_by, updated_by,status,leave_id', 'numerical', 'integerOnly'=>true),
			array('ticket_amt', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id,date_apply,leave_id,status, payment_date, ticket_amt, payment_mode, year, created_date_time, created_by, updated_date_time, updated_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'employeeleavedetail' => array(self::BELONGS_TO, 'EmployeeLeaveDetail', 'leave_id'),
                    'leavedetail' => array(self::BELONGS_TO, 'MasLeave', 'leave_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'payment_date' => 'Payment Date',
			'ticket_amt' => 'Ticket Amt',
			'payment_mode' => 'Payment Mode',
			'year' => 'Year',
			'created_date_time' => 'Created Date Time',
			'created_by' => 'Created By',
			'updated_date_time' => 'Updated Date Time',
			'updated_by' => 'Updated By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('payment_date',$this->payment_date,true);
		$criteria->compare('ticket_amt',$this->ticket_amt,true);
		$criteria->compare('payment_mode',$this->payment_mode);
		$criteria->compare('year',$this->year);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeTicket the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getStatus($id) {  
            switch ($id) {    
                case 1:    		
                    $status = "Applied";    
                    break;    	
                case 2:    	
                    $status = "Approved";    
                    break;    	
                case 3:  
                    $status = "Rejected";   
                    break; 
                case 4:  
                    $status = "Payment Released";   
                    break;             
                default:    	
                    $status = "Applied";  
            }    
            return $status;  
        }
}
