<?php

/**
 * This is the model class for table "crm_employee_documents".
 *
 * The followings are the available columns in table 'crm_employee_documents':
 * @property integer $id
 * @property integer $employee_id
 * @property string $description
 * @property string $document_number
 * @property string $validate_till_date
 * @property string $renew_on
 */
class EmployeeShift extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return EmployeeDocument the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_employee_shift}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public $employee_code, $employee_name, $shift_name;

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('employee_id,branch_id,shift_id,from_date,to_date', 'required'),
            array('employee_id', 'numerical', 'integerOnly' => true),
            array('from_date', 'validateshiftdate', 'on' => 'excelupload'),
            array('from_date', 'validatefromDate', 'on' => 'excelupload'),
            array('to_date', 'validatetoDate', 'on' => 'excelupload'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, employee_id, shift_id,from_date,to_date,created_by,created_date_time,updated_by,updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
            'shiftdetails' => array(self::BELONGS_TO, 'MasShift', 'shift_id'),
            'branchdetails' => array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'branch_id'),
        );
    }
    public function validateshiftdate($attribute) {
        if($this->employee_id!=''){
            if ($this->from_date!='0000-00-00' && $this->from_date!='' && $this->to_date!='0000-00-00' && $this->to_date!='') {
                if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $this->from_date) && preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $this->to_date)) {
                    if(strtotime($this->from_date)<=strtotime($this->to_date)){
                        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $this->from_date . '" AND to_date>="' . $this->to_date . '") OR  (from_date BETWEEN  "' . $this->from_date . '" AND  "' . $this->to_date . '"
                                        OR to_date BETWEEN  "' . $this->from_date . '" AND  "' . $this->to_date . '")) AND employee_id="' .$this->employee_id. '"'));
                        if(!empty($model_shift)){
                            $this->addError($attribute, 'Shift already exist from '.date("d/m/Y",strtotime($model_shift->from_date)).' - '.date("d/m/Y",strtotime($model_shift->to_date)));
                            return false;
                        }else{
                            return true;
                        }
                    }else{
                        $this->addError($attribute, 'Start Date must be less that End Date');
                        return false;
                    }
                }else {
                    $this->addError($attribute, 'Not in YYYY-mm-dd Format');
                    return false;
                }
            } else {
                $this->addError($attribute, 'Please Enter Date in Given Format');
                return false;
            }
        }else{
            $this->addError($attribute, 'Employee Code doesnot exist');
            return false;
        }
    }
    public function validatefromDate($attribute) {
        $date = $this->from_date;
        if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $date)) {
            return true;
        } else {
            $this->addError($attribute, 'Not in YYYY-mm-dd Format');
            return false;
        }
    }
    public function validatetoDate($attribute) {
        $date = $this->to_date;
        if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $date)) {
            return true;
        } else {
            $this->addError($attribute, 'Not in YYYY-mm-dd Format');
            return false;
        }
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'employee_id' => 'Employee',
            'shift_id' => 'Shift',
            'from_date' => 'From Date',
            'to_date' => 'To Date',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('employee_id', $this->employee_id);
        $criteria->compare('shift_id', $this->shift_id, true);
        $criteria->compare('from_date', $this->from_date, true);
        $criteria->compare('to_date', $this->to_date, true);
        $criteria->compare('created_by', $this->created_by, true);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by, true);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

}
