<?php

/**
 * This is the model class for table "{{hr_employee_salary_deduction_leave}}".
 *
 * The followings are the available columns in table '{{hr_employee_salary_deduction_leave}}':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $leave_id
 * @property integer $leave_type_id
 * @property string $leave_date
 * @property string $salary_deduction_type
 * @property integer $created_by
 * @property string $created_date_time
 */
class EmployeeSalaryDeductionLeave extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_salary_deduction_leave}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, leave_id, leave_type_id, leave_date, salary_deduction_type, created_by, created_date_time', 'required'),
			array('employee_id, leave_id, leave_type_id, created_by', 'numerical', 'integerOnly'=>true),
			array('salary_deduction_type', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, leave_id, leave_type_id, leave_date, salary_deduction_type, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'leavetype' => array(self::BELONGS_TO, 'MasLeave', 'leave_type_id'),
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'leavedetail' => array(self::BELONGS_TO, 'EmployeeLeaveDetail', 'leave_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'leave_id' => 'Leave',
			'leave_type_id' => 'Leave Type',
			'leave_date' => 'Leave Date',
			'salary_deduction_type' => 'F-Full,H-Half',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('leave_id',$this->leave_id);
		$criteria->compare('leave_type_id',$this->leave_type_id);
		$criteria->compare('leave_date',$this->leave_date,true);
		$criteria->compare('salary_deduction_type',$this->salary_deduction_type,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeSalaryDeductionLeave the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
