<?php


class EmployeeSalaryAdvance extends CActiveRecord {

 
    public function tableName() {
        return '{{hr_employee_salary_advance}}';
    }

 
    public $employee_name;
    
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('employee_id,amount,payment_note', 'required'),         	
            array('function_type,last_approved_level', 'numerical', 'integerOnly' => true),
            array('isActive', 'length', 'max' => 1),	
            array('approval_document', 'length', 'max' => 500),	
            array('amount', 'validateamount'),
            array('function_type', 'validatefunctiontype'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('employee_id', 'numerical', 'integerOnly' => true),
            array('id,employee_id,amount,amount_paid,apply_date,approved_date,advance_payment_date,credit_account,cheque_no,cheque_date,payment_note,isActive','safe', 'on' => 'search'),
        );
    }
    public function validatefunctiontype() {
        if ($this->function_type == '' || $this->function_type ==0) {
            $this->addError('function_type', 'Approval level missing.Contact HR');
            $this->rules();
        }
        return true;
    }
    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
            'approvelevel' => array(self::BELONGS_TO, 'HrEmployeeApproveLevel', 'function_type'),
            'level1' => array(self::BELONGS_TO, 'Employee', 'approve_level1_id'),
            'level2' => array(self::BELONGS_TO, 'Employee', 'approve_level2_id'),
            'level3' => array(self::BELONGS_TO, 'Employee', 'approve_level3_id'),
            'level4' => array(self::BELONGS_TO, 'Employee', 'approve_level4_id'),
            'level5' => array(self::BELONGS_TO, 'Employee', 'approve_level5_id'),
            'finalapprove' => array(self::BELONGS_TO, 'Employee', 'approved_by'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'employee_id'=>'Employee ID',          
            'amount'=>'Advance Amount',
          
        );
    }
     public function validateamount(){
            if($this->amount < 0){
                $this->addError('amount','Amount cannot be negative');
                $this->rules();
            }
                return true;
        }
   
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    public static function getStatus($id) {
        switch ($id) {
            case 1:
                $status = "Applied";
                break;
            case 2:
                $status = "Level 1 Approved";
                break;
            case 3:
                $status = "Level 1 Rejected";
                break;
            case 4:
                $status = "Level 2 Approved";
                break;
            case 5:
                $status = "Level 2 Rejected";
                break;
            case 6:
                $status = "Level 3 Approved";
                break;
            case 7:
                $status = "Level 3 Rejected";
                break;
            case 8:
                $status = "Level 4 Approved";
                break;
            case 9:
                $status = "Level 4 Rejected";
                break;
            case 10:
                $status = "Level 5 Approved";
                break;
            case 11:
                $status = "Level 5 Rejected";
                break;
            case 12:
                $status = "Approved";
                break;
            case 13:
                $status = "Rejected";
                break;
            case 14:
                $status = "Payment Released";
                break;
            case 15:
                $status = "Repayment Pending";
                break;
            case 16:
                $status = "Repayment Completed";
        }
        return $status;
    }
    public static function getPendingapproval($branch, $from) {
        $condition = 'employeedetail.isActive="Y" AND t.last_approved_level<t.max_level';
        if ($branch > 0) {
            $condition .= ' AND employeedetail.branch_or_sponsor_id="' . $branch . '"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        $model_details = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $arr_id = array();
        $salaryadvance_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->advance_payment_status != 3 && $value->advance_payment_status != 5 && $value->advance_payment_status != 7 && $value->advance_payment_status != 9 && $value->advance_payment_status != 11) {
                if($value->advance_payment_status<12){    
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && $value->approvelevel->level_1_type == 'H' && $value->approvelevel->level_1_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && $value->approvelevel->level_2_type == 'H' && $value->approvelevel->level_2_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && $value->approvelevel->level_3_type == 'H' && $value->approvelevel->level_3_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && $value->approvelevel->level_4_type == 'H' && $value->approvelevel->level_4_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && $value->approvelevel->level_5_type == 'H' && $value->approvelevel->level_5_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $salaryadvance_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $salaryadvance_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }

    public static function getintermediateapproval($employee_id, $from) {
        $model_details = self::model()->with('employeedetail', 'approvelevel')->findAll(array('condition' => 'employeedetail.isActive="Y" AND t.last_approved_level<t.max_level'));
        $arr_id = array();
        $salaryadvance_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->advance_payment_status != 3 && $value->advance_payment_status != 5 && $value->advance_payment_status != 7 && $value->advance_payment_status != 9 && $value->advance_payment_status != 11) {
                if($value->advance_payment_status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $salaryadvance_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $salaryadvance_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }
      
}
