<?php

/**
 * This is the model class for table "crm_hr_employee_salary".
 *
 * The followings are the available columns in table 'crm_hr_employee_salary':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $salary_type
 * @property string $amount
 * @property string $valid_from
 * @property string $valid_to
 * @property string $consider_for_leave_payment
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class EmployeeSalary extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_salary}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
        public $emp_code;
        public $salary_name;
        public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('salary_type, amount, valid_from', 'required'),
                        array('salary_type, amount, valid_from', 'required', 'on' => 'excelupload'),
                        array('employee_id', 'checkdataexist', 'on' => 'excelupload'),
                        array('valid_from', 'validatesalarydate', 'on' => 'excelupload'),
                        array('valid_from', 'validatestartDate', 'on' => 'excelupload'),
			array('employee_id, salary_type, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('amount', 'length', 'max'=>10),
			array('amount', 'validateamount'),
			array('consider_for_leave_payment, isActive', 'length', 'max'=>1),
                        array('salary_type', 'validatesalarycomponent'),//added on 9/8/2022 by DIkson R
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, salary_type, amount, valid_from, valid_to, consider_for_leave_payment, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}
        public function validatesalarycomponent() {

            if ($this->employee_id!= '' && $this->salary_type!='' && $this->valid_from!='' && $this->valid_from!='0000-00-00') {
                if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $this->valid_from)) {
                    $condition='((valid_from<="' . $this->valid_from . '" AND valid_to>="' . $this->valid_from . '") OR  (valid_from BETWEEN  "' . $this->valid_from . '" AND  "' . $this->valid_from . '"
                                    OR valid_to BETWEEN  "' . $this->valid_from . '" AND  "' . $this->valid_from . '")) AND employee_id="'.$this->employee_id.'" AND salary_type="'.$this->salary_type.'"';
                    $model = self::model()->find(array('condition'=>$condition));
                    if(!empty($model) && $model->id>0){
                        $this->addError('salary_type', 'Salary Component already added in this date range by '.$model->userdetails->Fullname);
                        return false;
                    }else{
                        return true;
                    }
                }else {
                    $this->addError('valid_from', 'Not in YYYY-mm-dd Format');
                    return false;
                }
            }

        }
        function afterSave() {
            $model_audit_log = new HrAuditLog();
            $model_audit_log->functionality = 2;
            $model_audit_log->master_table_id = $this->id;
            $model_audit_log->performed_by = Yii::app()->user->id;
            $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
            $model_audit_log->remarks ='Salary Details Created for employee code '.$this->employeedetail->employeecode;
            $model_audit_log->save();
        }
        public function validateamount(){
            if($this->amount < 0){
                $this->addError('amount','Salary should not be negative');
                $this->rules();
            }
                return true;
        }
        public function checkdataexist($attribute) {
            $model_salary = EmployeeSalary::model()->findAll(array('condition'=>'employee_id="'.$this->employee_id.'"'));
            if (!empty($model_salary)) {
                $this->addError($attribute, 'Salary Details already added for this employee');
                return false;
            } else {
                return true;
            }
        }
	public function validatesalarydate($attribute) {
            if($this->employee_id!=''){
                $model_employee = Employee::model()->findbyPK($this->employee_id);
                if ($model_employee->date_join!='0000-00-00') {
                    if(strtotime($this->valid_from)<strtotime($model_employee->date_join)){
                        $this->addError($attribute, 'Start Date Cannot be less than Joining Date');
                        return false;
                    }else{
                        return true;
                    }
                } else {
                    $this->addError($attribute, 'Please fill Date of Joining in Employee');
                    return false;
                }
            }else{
                $this->addError($attribute, 'Employee Code doesnot exist');
                return false;
            }
        }
        public function validatestartDate($attribute) {
            $date = $this->valid_from;
            if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $date)) {
                return true;
            } else {
                $this->addError($attribute, 'Not in YYYY-mm-dd Format');
                return false;
            }
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'salary' => array(self::BELONGS_TO, 'MasSalarytype', 'salary_type'),
                    'employeedetail'=>array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'userdetails' => array(self::BELONGS_TO, 'User', 'created_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'salary_type' => 'Salary Type',
			'amount' => 'Amount',
			'valid_from' => 'Valid From',
			'valid_to' => 'Valid To',
			'consider_for_leave_payment' => 'Y->yes,N->no',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('salary_type',$this->salary_type);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('valid_from',$this->valid_from,true);
		$criteria->compare('valid_to',$this->valid_to,true);
		$criteria->compare('consider_for_leave_payment',$this->consider_for_leave_payment,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeSalary the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
