<?php

/**
 * This is the model class for table "{{hr_employee_resignation}}".
 *
 * The followings are the available columns in table '{{hr_employee_resignation}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $reason
 * @property string $last_date
 * @property integer $notice_type
 * @property string $LM_approval_date
 * @property string $LM_notes
 * @property string $HR_approval_date
 * @property string $HR_notes
 * @property integer $status
 */
class EmployeeResignation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_resignation}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, reason, notice_type', 'required'),
			array('employee_id, notice_type, status,function_type,last_approved_level', 'numerical', 'integerOnly'=>true),
                        array('function_type', 'validatefunctiontype'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, reason, last_date, notice_type, status', 'safe', 'on'=>'search'),
		);
	}
        public function validatefunctiontype() {
            if ($this->function_type == '') {
                $this->addError('function_type', 'Approval level missing.Contact HR');
                $this->rules();
            }
            return true;
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'noticeperioddetail' => array(self::BELONGS_TO, 'MasNoticeperiod', 'notice_type'),
                    'approvelevel' => array(self::BELONGS_TO, 'HrEmployeeApproveLevel', 'function_type'),
                    'level1' => array(self::BELONGS_TO, 'Employee', 'approve_level1_id'),
                    'level2' => array(self::BELONGS_TO, 'Employee', 'approve_level2_id'),
                    'level3' => array(self::BELONGS_TO, 'Employee', 'approve_level3_id'),
                    'level4' => array(self::BELONGS_TO, 'Employee', 'approve_level4_id'),
                    'level5' => array(self::BELONGS_TO, 'Employee', 'approve_level5_id'),
                    'finalapprove' => array(self::BELONGS_TO, 'Employee', 'approved_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'reason' => 'Reason',
			'last_date' => 'Last Date',
			'notice_type' => 'Notice Type',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('reason',$this->reason,true);
		$criteria->compare('last_date',$this->last_date,true);
		$criteria->compare('notice_type',$this->notice_type);
		$criteria->compare('status',$this->status);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeResignation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getStatus($id) {
            switch ($id) {
                case 1:
                    $status = "Applied";
                    break;
                case 2:
                    $status = "Level 1 Approved";
                    break;
                case 3:
                    $status = "Level 1 Rejected";
                    break;
                case 4:
                    $status = "Level 2 Approved";
                    break;
                case 5:
                    $status = "Level 2 Rejected";
                    break;
                case 6:
                    $status = "Level 3 Approved";
                    break;
                case 7:
                    $status = "Level 3 Rejected";
                    break;
                case 8:
                    $status = "Level 4 Approved";
                    break;
                case 9:
                    $status = "Level 4 Rejected";
                    break;
                case 10:
                    $status = "Level 5 Approved";
                    break;
                case 11:
                    $status = "Level 5 Rejected";
                    break;
                case 12:
                    $status = "Approved";
                    break;
                case 13:
                    $status = "Rejected";
                    break;
            }
            return $status;
        }
        public static function getEmployee($branch_id=0)
        {		
            $condition='employeedetail.isActive="Y"';
            if($branch_id>0){
                $condition=' AND employeedetail.branch_or_sponsor_id="'.$branch_id.'"';
  
            }
            $model = self::model()->with('employeedetail')->findAll(array('condition'=>$condition));
            $arr_employee=array();
            $employee_details=array();
            foreach ($model as $key => $value) {
                $arr_employee[Yii::app()->controller->ciphertext($value->employeedetail->first_name,"d").' '.Yii::app()->controller->ciphertext($value->employeedetail->last_name,"d")]=$value->employee_id;
            }
            ksort($arr_employee);
            $m=0;
            foreach ($arr_employee as $k => $id) { 
                $employee_details[$m]['id']=$id;
                $employee_details[$m]['name']=$k;
                $m++;
            }
            return CHtml::listData($employee_details, 'id', 'name');
    }
    public static function getPendingapproval($branch, $from) {
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level';
        if ($branch > 0) {
            $condition .= ' AND employeedetail.branch_or_sponsor_id="' . $branch . '"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        $model_details = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $arr_id = array();
        $resignation_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->status != 3 && $value->status != 5 && $value->status != 7 && $value->status != 9 && $value->status != 11) {
                if($value->status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && $value->approvelevel->level_1_type == 'H' && $value->approvelevel->level_1_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && $value->approvelevel->level_2_type == 'H' && $value->approvelevel->level_2_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && $value->approvelevel->level_3_type == 'H' && $value->approvelevel->level_3_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && $value->approvelevel->level_4_type == 'H' && $value->approvelevel->level_4_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && $value->approvelevel->level_5_type == 'H' && $value->approvelevel->level_5_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $resignation_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $resignation_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }

    public static function getintermediateapproval($employee_id, $from) {
        $model_details = self::model()->with('employeedetail', 'approvelevel')->findAll(array('condition' => 'employeedetail.isActive="Y" AND last_approved_level<t.max_level'));
        $arr_id = array();
        $resignation_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->status != 3 && $value->status != 5 && $value->status != 7 && $value->status != 9 && $value->status != 11) {
                if($value->status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $resignation_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $resignation_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }
    public static function getmailStatus($id) {  
            switch ($id) {    
                case 1:    		
                    $status = "Applied";    
                    break;    	
                case 2:    	
                    $status = "Approved";    
                    break;    	
                case 3:  
                    $status = "Rejected";   
                    break; 
                case 4:  
                    $status = "Approved";   
                    break;
                case 5:  
                    $status = "Rejected";   
                    break; 
                default:    	
                    $status = "Applied";  
            }    
            return $status;  
        }
}
