<?php

/**
 * This is the model class for table "{{hr_employee_pension}}".
 *
 * The followings are the available columns in table '{{hr_employee_pension}}':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $salary_slip_id
 * @property string $employee_contribution_amount
 * @property string $company_contribution_amount
 * @property string $total_pension_amount
 * @property string $created_date
 */
class EmployeePension extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_pension}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, salary_slip_id, employee_contribution_amount, company_contribution_amount, total_pension_amount, created_date', 'required'),
			array('employee_id, salary_slip_id', 'numerical', 'integerOnly'=>true),
			array('employee_contribution_amount, company_contribution_amount, total_pension_amount', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, salary_slip_id, employee_contribution_amount, company_contribution_amount, total_pension_amount, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'salary_slip_id' => 'Salary Slip',
			'employee_contribution_amount' => 'Employee Contribution Amount',
			'company_contribution_amount' => 'Company Contribution Amount',
			'total_pension_amount' => 'Total Pension Amount',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('salary_slip_id',$this->salary_slip_id);
		$criteria->compare('employee_contribution_amount',$this->employee_contribution_amount,true);
		$criteria->compare('company_contribution_amount',$this->company_contribution_amount,true);
		$criteria->compare('total_pension_amount',$this->total_pension_amount,true);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeePension the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
