<?php

/**
 * This is the model class for table "{{employee_notice_conduct}}".
 *
 * The followings are the available columns in table '{{employee_notice_conduct}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $reason
 * @property string $notice_document
 * @property integer $issued_date
 * @property integer $view_status
 * @property integer $created_by
 * @property string $created_date_time
 */
class EmployeeNoticeConduct extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_notice_conduct}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, reason,type', 'required'),
			array('employee_id, view_status, created_by,year,month', 'numerical', 'integerOnly'=>true),
			array('month_1_amount, month_2_amount,month_3_amount', 'numerical'),
			array('notice_document', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, reason, notice_document, issued_date, view_status, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'reason' => 'Reason',
			'notice_document' => 'Notice Document',
			'issued_date' => 'Issued Date',
			'view_status' => 'View Status',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('reason',$this->reason,true);
		$criteria->compare('notice_document',$this->notice_document,true);
		$criteria->compare('issued_date',$this->issued_date);
		$criteria->compare('view_status',$this->view_status);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeNoticeConduct the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
