<?php

/**
 * This is the model class for table "{{hr_employee_loan_detail}}".
 *
 * The followings are the available columns in table '{{hr_employee_loan_detail}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $apply_date
 * @property string $loan_amount
 * @property string $loan_repayment
 * @property string $loan_monthly_payment
 * @property integer $loan_total_installment
 * @property string $approved_date
 * @property integer $approved_by
 * @property string $loan_taken
 * @property integer $credit_account
 * @property string $cheque_date
 * @property string $cheque_no
 * @property integer $loan_status
 * @property string $loan_posted
 * @property string $isActive
 */
class EmployeeLoanDetail extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_employee_loan_detail}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('employee_id, apply_date, loan_amount,proposed_installment,proposed_monthly_installment,repayment_start_month,repayment_start_year', 'required'),
            array('employee_id, loan_total_installment, approved_by, credit_account, loan_status,function_type,last_approved_level', 'numerical', 'integerOnly' => true),
            array('loan_amount, loan_repayment', 'length', 'max' => 10),
            array('loan_monthly_payment', 'length', 'max' => 15),
            array('loan_status', 'checkloanstatus'),
            array('loan_amount', 'validateamount'),
            array('repayment_start_month', 'validateLoanMonth', 'except' => 'payment'),
            array('function_type', 'validatefunctiontype'),
            array('cheque_no', 'length', 'max' => 50),
            array('loan_posted, isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, employee_id, apply_date, loan_amount, loan_repayment, loan_monthly_payment, loan_total_installment, approved_date, approved_by, loan_taken, credit_account, cheque_date, cheque_no, loan_status, loan_posted, isActive', 'safe', 'on' => 'search'),
        );
    }

    public function validatefunctiontype() {
        if ($this->function_type == '' || $this->function_type ==0) {
            $this->addError('function_type', 'Approval level missing.Contact HR');
            $this->rules();
        }
        return true;
    }

    /**
     * @return array relational rules.
     */
    public function validateamount() {
        if ($this->loan_amount < 0) {
            $this->addError('loan_amount', 'Amount cannot be negative');
            $this->rules();
        }
        return true;
    }
    
    public function validateLoanMonth() {
        if (!empty($this->repayment_start_month) && !empty($this->repayment_start_year)) {
            $inputMonth = (int) $this->repayment_start_month;
            $inputYear = (int) $this->repayment_start_year;
            $employee = Employee::model()->findByPk($this->employee_id);
            $latestSalary = SalaryProcessing::model()->find(array(
                'condition' => 'payroll_branch_or_sponsor_id = :branch',
                'params' => array(':branch' => $employee->branch_or_sponsor_id),
                'order' => 'payroll_enddate DESC'
            ));
            if ($latestSalary) {
                $latestMonth = (int) date('m', strtotime($latestSalary->payroll_enddate));
                $latestYear = (int) date('Y', strtotime($latestSalary->payroll_enddate));
                $latestMonthName = date('F', strtotime($latestSalary->payroll_enddate));
                if ($inputYear < $latestYear || ($inputYear == $latestYear && $inputMonth < $latestMonth)) {
                    $this->addError('repayment_start_month','Loan cannot be applied before the last salary processed month: ' . $latestMonthName . ' ' . $latestYear . '.');
                    return true;
                }
                if ($inputYear == $latestYear && $inputMonth == $latestMonth) {
                    $salaryExists = SalaryProcessing::model()->find(array(
                        'condition' =>
                        'payroll_branch_or_sponsor_id = :branch 
                         AND MONTH(payroll_enddate) = :m 
                         AND YEAR(payroll_enddate) = :y',
                        'params' => array(
                            ':branch' => $employee->branch_or_sponsor_id,
                            ':m' => $inputMonth,
                            ':y' => $inputYear
                        )
                    ));
                    if ($salaryExists) {
                        $this->addError('repayment_start_month', 'Salary already processed for this month.');
                        return true;
                    }
                }
            }
        }
        return true;
    }

    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
            'approvelevel' => array(self::BELONGS_TO, 'HrEmployeeApproveLevel', 'function_type'),
            'level1' => array(self::BELONGS_TO, 'Employee', 'approve_level1_id'),
            'level2' => array(self::BELONGS_TO, 'Employee', 'approve_level2_id'),
            'level3' => array(self::BELONGS_TO, 'Employee', 'approve_level3_id'),
            'level4' => array(self::BELONGS_TO, 'Employee', 'approve_level4_id'),
            'level5' => array(self::BELONGS_TO, 'Employee', 'approve_level5_id'),
            'hradmin' => array(self::BELONGS_TO, 'Employee', 'approved_by'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'employee_id' => 'Employee',
            'apply_date' => 'Apply Date',
            'loan_amount' => 'Loan Amount',
            'loan_repayment' => 'Loan Repayment',
            'loan_monthly_payment' => 'Loan Monthly Payment',
            'loan_total_installment' => 'Loan Total Installment',
            'approved_date' => 'Approved Date',
            'approved_by' => 'Approved By',
            'loan_taken' => 'Loan Taken',
            'credit_account' => 'Credit Account',
            'cheque_date' => 'Cheque Date',
            'cheque_no' => 'Cheque No',
            'loan_status' => '0-Applied,1-Approved,2-Rejected,3-Completed',
            'loan_posted' => 'Loan Posted',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('employee_id', $this->employee_id);
        $criteria->compare('apply_date', $this->apply_date, true);
        $criteria->compare('loan_amount', $this->loan_amount, true);
        $criteria->compare('loan_repayment', $this->loan_repayment, true);
        $criteria->compare('loan_monthly_payment', $this->loan_monthly_payment, true);
        $criteria->compare('loan_total_installment', $this->loan_total_installment);
        $criteria->compare('approved_date', $this->approved_date, true);
        $criteria->compare('approved_by', $this->approved_by);
        $criteria->compare('loan_taken', $this->loan_taken, true);
        $criteria->compare('credit_account', $this->credit_account);
        $criteria->compare('cheque_date', $this->cheque_date, true);
        $criteria->compare('cheque_no', $this->cheque_no, true);
        $criteria->compare('loan_status', $this->loan_status);
        $criteria->compare('loan_posted', $this->loan_posted, true);
        $criteria->compare('isActive', $this->isActive, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return EmployeeLoanDetail the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getLoanStatus($id) {
        switch ($id) {
            case 1:
                $status = "Applied";
                break;
            case 2:
                $status = "Level 1 Approved";
                break;
            case 3:
                $status = "Level 1 Rejected";
                break;
            case 4:
                $status = "Level 2 Approved";
                break;
            case 5:
                $status = "Level 2 Rejected";
                break;
            case 6:
                $status = "Level 3 Approved";
                break;
            case 7:
                $status = "Level 3 Rejected";
                break;
            case 8:
                $status = "Level 4 Approved";
                break;
            case 9:
                $status = "Level 4 Rejected";
                break;
            case 10:
                $status = "Level 5 Approved";
                break;
            case 11:
                $status = "Level 5 Rejected";
                break;
            case 12:
                $status = "Approved";
                break;
            case 13:
                $status = "Rejected";
                break;
            case 14:
                $status = "Payment Released";
                break;
            case 15:
                $status = "Repayment Pending";
                break;
            case 16:
                $status = "Repayment Completed";
        }
        return $status;
    }

    public static function getmailStatus($id) {
        switch ($id) {
            case 1:
                $status = "Applied";
                break;
            case 2:
                $status = "Level 1 Approved";
                break;
            case 3:
                $status = "Level 1 Rejected";
                break;
            case 4:
                $status = "Level 2 Approved";
                break;
            case 5:
                $status = "Level 2 Rejected";
                break;
            case 6:
                $status = "Level 3 Approved";
                break;
            case 7:
                $status = "Level 3 Rejected";
                break;
            case 8:
                $status = "Level 4 Approved";
                break;
            case 9:
                $status = "Level 4 Rejected";
                break;
            case 10:
                $status = "Level 5 Approved";
                break;
            case 11:
                $status = "Level 5 Rejected";
                break;
            case 12:
                $status = "Approved";
                break;
            case 13:
                $status = "Rejected";
                break;
            case 14:
                $status = "Payment Released";
                break;
            case 15:
                $status = "Repayment Pending";
                break;
            case 16:
                $status = "Repayment Completed";
        }
        return $status;
    }

    public static function getEmployeeName() {

        $condition = "1=1";
        $SQL = "SELECT loan.id,loan.loan_total_installment, emp.branch_or_sponsor_id, emp.employee_code,  emp.first_name , emp.middle_name , emp.last_name FROM crm_hr_employee emp 
						INNER JOIN crm_hr_employee_loan_detail loan on emp.id=loan.employee_id
						where $condition and emp.isActive='Y'and loan.loan_status='1'   ";

        $model = Yii::app()->db->createCommand($SQL)->queryAll();

        return CHtml::listData($model, 'emp.id', 'loan.loan_repayment');
    }

    public static function getEmployee($branch_id = 0) {
        $condition = 'employeedetail.isActive="Y"';
        if ($branch_id > 0) {
            $condition.= ' AND employeedetail.branch_or_sponsor_id="' . $branch_id . '"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        $model = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $arr_employee = array();
        $employee_details = array();
        foreach ($model as $key => $value) {
            $arr_employee[$value->employeedetail->employeefullname] = $value->employee_id;
        }
        ksort($arr_employee);
        $m = 0;
        foreach ($arr_employee as $k => $id) {
            $employee_details[$m]['id'] = $id;
            $employee_details[$m]['name'] = $k;
            $m++;
        }
        return CHtml::listData($employee_details, 'id', 'name');
    }

    public function checkloanstatus() {
        if ($this->loan_status == 12 && $this->loan_monthly_payment == 0 && $this->loan_total_installment == 0) {
            $this->addError('loan_monthly_payment', 'Loan Montly payment cannot be blank');
            $this->rules();
        }
        return true;
    }

    public static function getPendingapproval($branch, $from) {
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level';
        if ($branch > 0) {
            $condition .= ' AND employeedetail.branch_or_sponsor_id="' . $branch . '"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        $model_details = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $arr_id = array();
        $loan_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->loan_status != 3 && $value->loan_status != 5 && $value->loan_status != 7 && $value->loan_status != 9 && $value->loan_status != 11) {
                if($value->loan_status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if (!empty($value->approvelevel) && $next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && $value->approvelevel->level_1_type == 'H' && $value->approvelevel->level_1_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && $value->approvelevel->level_2_type == 'H' && $value->approvelevel->level_2_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && $value->approvelevel->level_3_type == 'H' && $value->approvelevel->level_3_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && $value->approvelevel->level_4_type == 'H' && $value->approvelevel->level_4_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && $value->approvelevel->level_5_type == 'H' && $value->approvelevel->level_5_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $loan_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $loan_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }

    public static function getintermediateapproval($employee_id, $from) {
        $model_details = self::model()->with('employeedetail', 'approvelevel')->findAll(array('condition' => 'employeedetail.isActive="Y" AND last_approved_level<t.max_level'));
        $arr_id = array();
        $loan_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->loan_status != 3 && $value->loan_status != 5 && $value->loan_status != 7 && $value->loan_status != 9 && $value->loan_status != 11) {
                if($value->loan_status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $loan_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $loan_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }

}
