<?php

/**
 * This is the model class for table "{{hr_employee_leavesettlement}}".
 *
 * The followings are the available columns in table '{{hr_employee_leavesettlement}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $date_rejoin
 * @property string $date_leave
 * @property integer $employee_service_days
 * @property string $employee_service_period
 * @property string $available_leaves
 * @property string $balance_leave
 * @property string $encashed_leaves
 * @property string $leave_salary
 * @property string $other_payments
 * @property string $settlement_amount
 * @property integer $prepared_by
 * @property integer $checked_by
 * @property integer $checked_finance_manger
 * @property integer $checked_gm
 * @property integer $status
 * @property string $posted
 */
class EmployeeLeavesettlement extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_leavesettlement}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, date_rejoin, date_leave, employee_service_days, employee_service_period, available_leaves, balance_leave, encashed_leaves, leave_salary, settlement_amount', 'required'),
			array('employee_id, prepared_by, checked_by, checked_finance_manger, checked_gm, status', 'numerical', 'integerOnly'=>true),
			array('employee_service_period', 'length', 'max'=>255),
			array('available_leaves, balance_leave, encashed_leaves, leave_salary, other_payments, settlement_amount', 'length', 'max'=>10),
			array('posted', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, date_rejoin, date_leave, employee_service_days,notes, employee_service_period, available_leaves, balance_leave, encashed_leaves, leave_salary, other_payments, settlement_amount, prepared_by, checked_by, checked_finance_manger, checked_gm, status, posted', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'date_rejoin' => 'Date Rejoin',
			'date_leave' => 'Date Leave',
			'employee_service_days' => 'Employee Service Days',
			'employee_service_period' => 'Employee Service Period',
			'available_leaves' => 'Available Leaves',
			'balance_leave' => 'Balance Leave',
			'encashed_leaves' => 'Encashed Leaves',
			'leave_salary' => 'Leave Salary',
			'other_payments' => 'Other Payments',
			'settlement_amount' => 'Settlement Amount',
			'prepared_by' => 'Primarykey from employee',
			'checked_by' => 'Primarykey from employee',
			'checked_finance_manger' => 'Primarykey from employee',
			'checked_gm' => 'Primarykey from employee',
			'status' => '0-not used in salary calculation,1-used in salary calculation',
			'posted' => 'Posted',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('date_rejoin',$this->date_rejoin,true);
		$criteria->compare('date_leave',$this->date_leave,true);
		$criteria->compare('employee_service_days',$this->employee_service_days);
		$criteria->compare('employee_service_period',$this->employee_service_period,true);
		$criteria->compare('available_leaves',$this->available_leaves,true);
		$criteria->compare('balance_leave',$this->balance_leave,true);
		$criteria->compare('encashed_leaves',$this->encashed_leaves,true);
		$criteria->compare('leave_salary',$this->leave_salary,true);
		$criteria->compare('other_payments',$this->other_payments,true);
		$criteria->compare('settlement_amount',$this->settlement_amount,true);
		$criteria->compare('prepared_by',$this->prepared_by);
		$criteria->compare('checked_by',$this->checked_by);
		$criteria->compare('checked_finance_manger',$this->checked_finance_manger);
		$criteria->compare('checked_gm',$this->checked_gm);
		$criteria->compare('status',$this->status);
		$criteria->compare('posted',$this->posted,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeLeavesettlement the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getStatus($id) {  
            switch ($id) {    
               case 1:    		
                $status = "Applied";    
                break;    	
            case 2:    	
                $status = "Approved";    
                break;    	
            case 3:  
                $status = "Rejected";   
                break; 
            case 4:  
                $status = "Payment Released";   
                break;
            default:    	
                $status = "Applied";    
            }    
            return $status;  
        }
}
