<?php

/**
 * This is the model class for table "{{hr_employee_leave_encashment}}".
 *
 * The followings are the available columns in table '{{hr_employee_leave_encashment}}':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $encashment_year
 * @property string $encashable_leave
 * @property string $encashment_amount
 * @property string $apply_date
 * @property string $approve_date
 * @property integer $credit_account
 * @property string $cheque_date
 * @property string $cheque_no
 * @property integer $status
 * @property integer $view_status
 * @property string $payment_status
 * @property string $finance_posted
 */
class EmployeeLeaveEncashment extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_leave_encashment}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
        public $employee_name;
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id,leave_type_id, encashment_year, encashable_leave, encashment_amount', 'required'),
			array('function_type,last_approved_level,employee_id, encashment_year, credit_account, status, view_status', 'numerical', 'integerOnly'=>true),
			array('encashable_leave, encashment_amount', 'length', 'max'=>10),
			array('cheque_no', 'length', 'max'=>50),
			array('payment_status, finance_posted', 'length', 'max'=>1),
                        array('function_type', 'validatefunctiontype'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, encashment_year, encashable_leave, encashment_amount, apply_date, approve_date, credit_account, cheque_date, cheque_no, status, view_status, payment_status, finance_posted', 'safe', 'on'=>'search'),
		);
	}
        public function validatefunctiontype() {
            if ($this->function_type == '') {
                $this->addError('function_type', 'Approval level missing.Contact HR');
                $this->rules();
            }
            return true;
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'leavetype' => array(self::BELONGS_TO, 'MasLeave', 'leave_type_id'),
                    'approvelevel' => array(self::BELONGS_TO, 'HrEmployeeApproveLevel', 'function_type'),
                    'level1' => array(self::BELONGS_TO, 'Employee', 'approve_level1_id'),
                    'level2' => array(self::BELONGS_TO, 'Employee', 'approve_level2_id'),
                    'level3' => array(self::BELONGS_TO, 'Employee', 'approve_level3_id'),
                    'level4' => array(self::BELONGS_TO, 'Employee', 'approve_level4_id'),
                    'level5' => array(self::BELONGS_TO, 'Employee', 'approve_level5_id'),
                    'finalapprove' => array(self::BELONGS_TO, 'Employee', 'approved_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'encashment_year' => 'Encashment Year',
			'encashable_leave' => 'Encashable Leave',
			'encashment_amount' => 'Encashment Amount',
			'apply_date' => 'Apply Date',
			'approve_date' => 'Approve Date',
			'credit_account' => 'Credit Account',
			'cheque_date' => 'Cheque Date',
			'cheque_no' => 'Cheque No',
			'status' => '1-Applied,2-Approved',
			'view_status' => '1-Not viewd,2-Viewed',
			'payment_status' => 'Payment Status',
			'finance_posted' => 'Finance Posted',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('encashment_year',$this->encashment_year);
		$criteria->compare('encashable_leave',$this->encashable_leave,true);
		$criteria->compare('encashment_amount',$this->encashment_amount,true);
		$criteria->compare('apply_date',$this->apply_date,true);
		$criteria->compare('approve_date',$this->approve_date,true);
		$criteria->compare('credit_account',$this->credit_account);
		$criteria->compare('cheque_date',$this->cheque_date,true);
		$criteria->compare('cheque_no',$this->cheque_no,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('view_status',$this->view_status);
		$criteria->compare('payment_status',$this->payment_status,true);
		$criteria->compare('finance_posted',$this->finance_posted,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeLeaveEncashment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getStatus($id) {
        switch ($id) {
            case 1:
                $status = "Applied";
                break;
            case 2:
                $status = "Level 1 Approved";
                break;
            case 3:
                $status = "Level 1 Rejected";
                break;
            case 4:
                $status = "Level 2 Approved";
                break;
            case 5:
                $status = "Level 2 Rejected";
                break;
            case 6:
                $status = "Level 3 Approved";
                break;
            case 7:
                $status = "Level 3 Rejected";
                break;
            case 8:
                $status = "Level 4 Approved";
                break;
            case 9:
                $status = "Level 4 Rejected";
                break;
            case 10:
                $status = "Level 5 Approved";
                break;
            case 11:
                $status = "Level 5 Rejected";
                break;
            case 12:
                $status = "Approved";
                break;
            case 13:
                $status = "Rejected";
                break;
            case 14:
                $status = "Payment Released";
                break;
        }
        return $status;
    }
    public static function getPendingapproval($branch, $from) {
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level';
        if ($branch > 0) {
            $condition .= ' AND employeedetail.branch_or_sponsor_id="' . $branch . '"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        $model_details = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $arr_id = array();
        $encashment_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->status != 3 && $value->status != 5 && $value->status != 7 && $value->status != 9 && $value->status != 11) {
                if($value->status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && $value->approvelevel->level_1_type == 'H' && $value->approvelevel->level_1_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && $value->approvelevel->level_2_type == 'H' && $value->approvelevel->level_2_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && $value->approvelevel->level_3_type == 'H' && $value->approvelevel->level_3_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && $value->approvelevel->level_4_type == 'H' && $value->approvelevel->level_4_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && $value->approvelevel->level_5_type == 'H' && $value->approvelevel->level_5_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $encashment_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $encashment_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }

    public static function getintermediateapproval($employee_id, $from) {
        $model_details = self::model()->with('employeedetail', 'approvelevel')->findAll(array('condition' => 'employeedetail.isActive="Y" AND last_approved_level<t.max_level'));
        $arr_id = array();
        $encashment_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->status != 3 && $value->status != 5 && $value->status != 7 && $value->status != 9 && $value->status != 11) {
                if($value->status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $encashment_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $encashment_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }
}
