<?php

/**
 * This is the model class for table "crm_hr_employee_inout_document".
 *
 * The followings are the available columns in table 'crm_hr_employee_inout_document':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $in_out_document_id
 * @property integer $in_out_type
 * @property string $in_out_date
 * @property string $in_out_remarks
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class EmployeeInoutDocument extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_inout_document}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('in_out_document_id, in_out_type, in_out_date, updated_date_time', 'required'),
			array('employee_id, in_out_document_id, in_out_type, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, in_out_document_id, in_out_type, in_out_date, in_out_remarks, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		  'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
		  'documentdetail' => array(self::BELONGS_TO, 'MasInoutDocument', 'in_out_document_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'in_out_document_id' => 'In Out Document',
			'in_out_type' => 'In Out Type',
			'in_out_date' => 'In Out Date',
			'in_out_remarks' => 'In Out Remarks',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('in_out_document_id',$this->in_out_document_id);
		$criteria->compare('in_out_type',$this->in_out_type);
		$criteria->compare('in_out_date',$this->in_out_date,true);
		$criteria->compare('in_out_remarks',$this->in_out_remarks,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeInoutDocument the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
