<?php

/**
 * This is the model class for table "{{hr_employee_expense_details}}".
 *
 * The followings are the available columns in table '{{hr_employee_expense_details}}':
 * @property integer $id
 * @property integer $expense_id
 * @property integer $employee_id
 * @property string $expense_date
 * @property string $notes
 * @property string $amount
 * @property string $file
 */
class EmployeeExpenseDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_expense_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('expense_date, expense_component_id,currency_id, amount,exchange_rate', 'required'),
			array('expense_id, employee_id,expense_component_id,currency_id', 'numerical', 'integerOnly'=>true),
			array('amount, file', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, expense_id, employee_id, expense_date, notes, amount,currency_id,exchange_rate,grand_total, file', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'expensedetail'=>array(self::BELONGS_TO, 'HrMasEmployeeExpense', 'expense_component_id'),
                     'currencydetail'=>array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'expense_id' => 'Expense',
			'employee_id' => 'Employee',
			'expense_date' => 'Expense Date',
			'notes' => 'Description',
			'amount' => 'Amount',
			'file' => 'File',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('expense_id',$this->expense_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('expense_date',$this->expense_date,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('file',$this->file,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeExpenseDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
