<?php

/**
 * This is the model class for table "{{hr_employee_eos_clearance_details}}".
 *
 * The followings are the available columns in table '{{hr_employee_eos_clearance_details}}':
 * @property integer $id
 * @property integer $eos_id
 * @property integer $clearance_id
 * @property integer $clearance_status
 */
class EmployeeEosClearanceDetails extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_employee_eos_clearance_details}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('eos_id,employee_id, clearance_id, clearance_status', 'required'),
            array('eos_id,employee_id, clearance_id, clearance_status', 'numerical', 'integerOnly' => true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, eos_id, clearance_id, clearance_status', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'eos_clearance' => array(self::BELONGS_TO, 'MasEOSClearance', 'clearance_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'eos_id' => 'Eos',
            'clearance_id' => 'Clearance',
            'clearance_status' => 'Clearance Type',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('eos_id', $this->eos_id);
        $criteria->compare('clearance_id', $this->clearance_id);
        $criteria->compare('clearance_status', $this->clearance_status);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return HrEmployeeEosClearanceDetails the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
