<?php

/**
 * This is the model class for table "{{hr_employee_eos}}".
 *
 * The followings are the available columns in table '{{hr_employee_eos}}':
 * @property integer $id
 * @property integer $branch_or_sponsor_id
 * @property string $apply_date
 * @property integer $employee_id
 * @property string $service_days
 * @property string $salary_advance
 * @property string $leave_amount
 * @property string $loan
 * @property string $overtime_salary
 * @property string $leave_settlement
 * @property string $gratuity
 * @property string $salary_start_date
 * @property string $date_leaving
 * @property string $notice_period_salary
 * @property string $employee_salary
 * @property string $addictions
 * @property string $addition_others
 * @property string $deductions
 * @property string $deduction_others
 * @property string $total_amount
 * @property integer $account_clearance
 * @property integer $dept_clearance
 * @property integer $original_passport
 * @property integer $emirate_id
 * @property integer $health_card
 * @property integer $visa_copy
 * @property integer $status
 * @property integer $credit_account
 * @property string $cheque_no
 * @property string $cheque_date
 * @property string $approve_date
 * @property string $paid
 * @property string $salary_posted
 * @property string $wps_posted
 */
class EmployeeEOS extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_eos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('branch_or_sponsor_id, apply_date, employee_id, service_days,gratuity, salary_start_date, date_leaving,total_amount', 'required'),
			array('branch_or_sponsor_id, employee_id, status, credit_account,notice_period_id', 'numerical', 'integerOnly'=>true),
			array('cheque_no', 'length', 'max'=>50),
			array('service_days, salary_advance, leave_amount, loan, overtime_salary, leave_settlement, gratuity, notice_period_salary, employee_salary, additions, addition_others, deductions, deduction_others, total_amount', 'length', 'max'=>15),
			array('finance_posted', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, branch_or_sponsor_id, apply_date, employee_id, service_days, salary_advance, leave_amount, loan, overtime_salary, leave_settlement, gratuity, salary_start_date, date_leaving, notice_period_salary, employee_salary, addition_others, deductions, deduction_others, total_amount,status, credit_account, cheque_no, cheque_date, approve_date, finance_posted', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail'=>array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'gratuityrule' => array(self::BELONGS_TO, 'HrMasGratuityRuleType', 'gratuity_rule_id')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'branch_or_sponsor_id' => 'Branch Or Sponsor',
			'apply_date' => 'Apply Date',
			'employee_id' => 'Employee',
			'service_days' => 'Service Days',
			'salary_advance' => 'Salary Advance',
			'leave_amount' => 'Leave Amount',
			'loan' => 'Loan',
			'overtime_salary' => 'Overtime Salary',
			'leave_settlement' => 'Leave Settlement',
			'gratuity' => 'Gratuity',
			'salary_start_date' => 'Salary Start Date',
			'date_leaving' => 'Date Leaving',
			'notice_period_salary' => 'Notice Period Salary',
			'employee_salary' => 'Employee Salary',
			'additions' => 'Additions',
			'addition_others' => 'Addition Others',
			'deductions' => 'Deductions',
			'deduction_others' => 'Deduction Others',
			'total_amount' => 'Total Amount',	
			'status' => 'Status',
			'credit_account' => 'Credit Account',
			'cheque_no' => 'Cheque No',
			'cheque_date' => 'Cheque Date',
			'approve_date' => 'Approve Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('branch_or_sponsor_id',$this->branch_or_sponsor_id);
		$criteria->compare('apply_date',$this->apply_date,true);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('service_days',$this->service_days,true);
		$criteria->compare('salary_advance',$this->salary_advance,true);
		$criteria->compare('leave_amount',$this->leave_amount,true);
		$criteria->compare('loan',$this->loan,true);
		$criteria->compare('overtime_salary',$this->overtime_salary,true);
		$criteria->compare('leave_settlement',$this->leave_settlement,true);
		$criteria->compare('gratuity',$this->gratuity,true);
		$criteria->compare('salary_start_date',$this->salary_start_date,true);
		$criteria->compare('date_leaving',$this->date_leaving,true);
		$criteria->compare('notice_period_salary',$this->notice_period_salary,true);
		$criteria->compare('employee_salary',$this->employee_salary,true);
		$criteria->compare('addictions',$this->addictions,true);
		$criteria->compare('addition_others',$this->addition_others,true);
		$criteria->compare('deductions',$this->deductions,true);
		$criteria->compare('deduction_others',$this->deduction_others,true);
		$criteria->compare('total_amount',$this->total_amount,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('credit_account',$this->credit_account);
		$criteria->compare('cheque_no',$this->cheque_no,true);
		$criteria->compare('cheque_date',$this->cheque_date,true);
		$criteria->compare('approve_date',$this->approve_date,true);
		$criteria->compare('finance_posted',$this->paid,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeEos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getStatus($id) {  
            switch ($id) {    
               case 1:    		
                $status = "Applied";    
                break;    	
            case 2:    	
                $status = "Approved";    
                break;    	
            case 3:  
                $status = "Rejected";   
                break; 
            case 4:  
                $status = "Payment Released";   
                break;
            default:    	
                $status = "Applied";    
            }    
            return $status;  
        }
}
