<?php

class EmployeeAttendance extends CActiveRecord
{
    public  $emp_id;
    public $time;
    public $file;

    /**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Leave the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_attendance}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id,attendance_date', 'required'),
			array('employee_id', 'numerical', 'integerOnly'=>true),			
			array('id,employee_id,shift_id, attendance_date, week_day, status,normal_overtime,holiday_overtime,logout_time,login_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'siteovertime' => array(self::BELONGS_TO, 'OrderManhours', 'order_manhours'),
                    'shift' => array(self::BELONGS_TO, 'EmployeeShift', 'shift_id'),
                    'leave' => array(self::BELONGS_TO, 'EmployeeLeaveDetail', 'leave_id'),
                    'branch_sponsor' => array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'branch_or_sponsor_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'attendance_date' => 'Date',
			'week_day' => 'Day',
			'status' => 'Status',
			'normal_overtime' => 'Normal Overtime',
			'holiday_overtime' => 'Holiday Overtime',
                    'logout_time'=>'Login Time',
                    'login_time'=>'Logout Time'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
    public static function getStatus($id) {
        switch ($id) {
            case 1:
                $status = "Present";
                break;
            case 2:
                $status = "Absent";
                break;
            case 3:
                $status = "Leave";
                break;
            case 4:
                $status = "Holiday";
                break;
            case 5:
                $status = "Weekend";
                break;
        }
        return $status;
    }
   
}