<?php

/**
 * This is the model class for table "crm_hr_employee_asset".
 *
 * The followings are the available columns in table 'crm_hr_employee_asset':
 * @property integer $id
 * @property integer $employee_id
 * @property string $master_asset_id
 * @property string $asset_description
 * @property string $asset_date_issue
 * @property string $asset_date_return
 * @property integer $asset_status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 * @property string $asset_undertaking_letter
 */
class EmployeeAsset extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_asset}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('asset_id,asset_date_issue,asset_status', 'required'),
			array('master_asset_id,employee_id,asset_id, asset_status, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
                        array('asset_id', 'validateasset'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, master_asset_id, asset_description, asset_date_issue, asset_date_return,asset_undertaking_letter, asset_status, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetails' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'assetdetails' => array(self::BELONGS_TO, 'HrMasAssetDetails', 'asset_id'),
                    'masterassetdetails' => array(self::BELONGS_TO, 'HrMasAsset', 'master_asset_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
        public function validateasset() {

            if ($this->asset_id == '') {
                $this->addError('asset_id', 'Please Select Asset');
                return false;
            }else if ($this->asset_id!= '' && $this->asset_status==1) {
                $condition='asset_id="'.$this->asset_id.'" AND asset_status="1"';
                if($this->id!=''){
                    $condition.=' AND id!="'.$this->id.'"';
                }
                $model = self::model()->find(array('condition'=>$condition));
                if(!empty($model) && $model->id>0){
                    $this->addError('asset_id', 'Asset already allocated');
                    return false;
                }else{
                    return true;
                }
            }

        }
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'asset_id' => 'Asset Name',
			'asset_description' => 'Asset Description',
			'asset_date_issue' => 'Asset Date Issue',
			'asset_date_return' => 'Asset Date Return',
			'asset_status' => 'Asset Status',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('master_asset_id',$this->master_asset_id);
		$criteria->compare('asset_description',$this->asset_description,true);
		$criteria->compare('asset_date_issue',$this->asset_date_issue,true);
		$criteria->compare('asset_date_return',$this->asset_date_return,true);
		$criteria->compare('asset_status',$this->asset_status);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeAsset the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
