<?php

/**
 * This is the model class for table "{{employee_leave_excuse}}".
 *
 * The followings are the available columns in table '{{employee_leave_excuse}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $request_date
 * @property string $excuse_reason
 * @property integer $status
 */
class ComplaintSuggestion extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_complaint_suggestion}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, complaint_suggestion', 'required'),
			array('employee_id, status', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, created_date, complaint_suggestion, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                      'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'created_date' => 'Created Date',
			'excuse_reason' => 'Reason',
			'status' => 'Status',
		);
	}

	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeLeaveExcuse the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        
}
