<?php

/**
 * This is the model class for table "{{hr_company_document}}".
 *
 * The followings are the available columns in table '{{hr_company_document}}':
 * @property integer $id
 * @property integer $company_id
 * @property string $description
 * @property string $document_number
 * @property integer $document_type
 * @property string $document_name
 * @property string $validate_till_date
 * @property string $renew_on
 * @property integer $status
 * @property string $inprocess_date
 */
class CompanyDocument extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_company_document}}';
	}
    public $renewal_day;
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id, document_id, document_number, document_type', 'required'),
			array('company_id, document_type,status', 'numerical', 'integerOnly'=>true),
			array('document_id, document_number', 'length', 'max'=>30),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id, document_id, document_number,inprocess_date, document_type, document_file, validate_till_date, renew_on, status, inprocess_date', 'safe', 'on'=>'search'),
		);
	}
        function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 27;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' company document '.$this->document_number;
        $model_audit_log->save();
    }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		'documentname' => array(self::BELONGS_TO, 'MasDocument', 'document_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'document_id' => 'Document Name',
			'document_number' => 'Document Number',
			'document_type' => 'Document Type',
			'document_file' => 'Document File',
			'validate_till_date' => 'Validate Till Date',
			'renew_on' => 'Renew On',
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('document_number',$this->document_number,true);
		$criteria->compare('document_type',$this->document_type);
		$criteria->compare('document_file',$this->document_file,true);
		$criteria->compare('validate_till_date',$this->validate_till_date,true);
		$criteria->compare('renew_on',$this->renew_on,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('inprocess_date',$this->inprocess_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrCompanyDocument the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getCompanyDocuments() {
            $condition = 'isActive =  "Y" ';
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_number asc'));
            return CHtml::listData($model, 'id', 'document_number');
        }
	
}
